/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class StreamAdapter
extends InputStream {
    public static final String FILE_PROTOCOL = "file";
    public static final String UTF8 = "UTF-8";
    private int mark = -1;
    private ByteBuffer buf;

    public StreamAdapter(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this.buf = buffer;
    }

    public int available() throws IOException {
        return this.buf.limit() - this.buf.position();
    }

    public int read() throws IOException {
        if (this.buf.position() == this.buf.limit()) {
            return -1;
        }
        return this.buf.get();
    }

    public void close() throws IOException {
        this.buf = null;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.buf.position();
    }

    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.buf.position(this.mark);
    }

    public boolean markSupported() {
        return true;
    }

    public static File toFile(URL url) {
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            try {
                return new File(URLDecoder.decode(url.getPath(), UTF8));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static URL toURL(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            URI uri = new URI(FILE_PROTOCOL, "//", file.toURL().getPath(), null);
            return new URL(FILE_PROTOCOL, null, uri.getRawPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream make(URL url) throws IOException {
        File file = StreamAdapter.toFile(url);
        if (file != null) {
            return StreamAdapter.make(file);
        }
        return url.openConnection().getInputStream();
    }

    public static InputStream make(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        MappedByteBuffer buffer = is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        return new StreamAdapter(buffer);
    }
}

