/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import edu.mit.jmwe.util.IProgressBar;
import java.util.Date;

public class ProgressBar
implements IProgressBar {
    public static final int DEFAULT_TICKS = 50;
    private final int expected;
    private final int expectedTicks;
    private final double step;
    private final boolean printDate;
    private int count = 0;
    private int tickCount = 0;
    private double nextTick = 0.0;
    private Date start = null;
    private Date end = null;

    public ProgressBar(int expected) {
        this(expected, 50);
    }

    public ProgressBar(int expected, int ticks) {
        this(expected, ticks, true);
    }

    public ProgressBar(int expected, int ticks, boolean printDate) {
        if (expected <= 0) {
            throw new IllegalArgumentException("Expected increments must be positive");
        }
        if (ticks <= 0) {
            throw new IllegalArgumentException("Number of printed ticks must be positive");
        }
        this.expected = expected;
        this.expectedTicks = ticks;
        this.nextTick = this.step = (double)expected / (double)ticks;
        this.printDate = printDate;
        StringBuilder sb = new StringBuilder(ticks);
        sb.append("100% bar: ");
        for (int i = 0; i < ticks; ++i) {
            sb.append('.');
        }
        sb.append(" (total=" + expected + ")");
        this.start = new Date();
        if (printDate) {
            System.out.println("Started " + this.start);
        }
        System.out.println(sb.toString());
        System.out.print("Progress: ");
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int i) {
        this.count += i;
        while (this.nextTick <= (double)this.count) {
            System.out.print('.');
            ++this.tickCount;
            this.nextTick += this.step;
        }
    }

    public void finish() {
        while (this.tickCount < this.expectedTicks) {
            System.out.print('.');
            ++this.tickCount;
        }
        this.end = new Date();
        long millis = this.end.getTime() - this.start.getTime();
        float secs = (float)millis / 1000.0f;
        System.out.println(" (count=" + this.count + ", time=" + secs + "s)");
        if (this.printDate) {
            System.out.println("Finished " + new Date());
        }
    }

    public int getExpected() {
        return this.expected;
    }

    public int getExpectedTicks() {
        return this.expectedTicks;
    }

    public Date getStartTime() {
        return this.start;
    }

    public Date getEndTime() {
        return this.end;
    }

    public int getCount() {
        return this.count;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getStepSize() {
        return this.step;
    }
}

