/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedIterator<T>
implements Iterator<T> {
    private final int limit;
    private final Iterator<? extends T> itr;
    private int count = 0;

    public LimitedIterator(Iterator<? extends T> backingItr, int limit) {
        if (backingItr == null) {
            throw new NullPointerException();
        }
        this.limit = limit;
        this.itr = backingItr;
    }

    @Override
    public boolean hasNext() {
        if (this.limit > 0 && this.count >= this.limit) {
            return false;
        }
        return this.itr.hasNext();
    }

    @Override
    public T next() {
        if (this.count >= this.limit) {
            throw new NoSuchElementException();
        }
        T next = this.itr.next();
        ++this.count;
        return next;
    }

    @Override
    public void remove() {
        this.itr.remove();
    }
}

