/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComparator<T>
extends AbstractList<Comparator<T>>
implements Comparator<T>,
List<Comparator<T>> {
    private final List<Comparator<T>> cs;

    public CompositeComparator(Comparator<T> one, Comparator<T> two) {
        this(Arrays.asList(one, two));
    }

    public CompositeComparator(Comparator<T> one, Comparator<T> two, Comparator<T> three) {
        this(Arrays.asList(one, two, three));
    }

    public CompositeComparator(Comparator<T> ... cs) {
        this(Arrays.asList(cs));
    }

    public CompositeComparator(List<? extends Comparator<T>> cs) {
        for (Comparator<T> c : cs) {
            if (c != null) continue;
            throw new NullPointerException();
        }
        this.cs = new ArrayList<Comparator<T>>(cs);
    }

    @Override
    public int compare(T one, T two) {
        for (Comparator<T> c : this.cs) {
            int cmp = c.compare(one, two);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public Comparator<T> get(int index) {
        return this.cs.get(index);
    }

    @Override
    public int size() {
        return this.cs.size();
    }
}

