/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCollection<E>
extends AbstractCollection<E> {
    protected final List<Collection<? extends E>> subsets;

    public CompositeCollection(Collection<? extends E> ... subsets) {
        this((Iterable<Collection<? extends E>>)Arrays.asList(subsets));
    }

    public CompositeCollection(Iterable<Collection<? extends E>> subsets) {
        ArrayList<Collection<E>> hidden = new ArrayList<Collection<E>>();
        for (Collection<E> collection : subsets) {
            if (collection == null) {
                throw new NullPointerException();
            }
            hidden.add(collection);
        }
        if (hidden.isEmpty()) {
            throw new IllegalArgumentException();
        }
        hidden.trimToSize();
        this.subsets = Collections.unmodifiableList(hidden);
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> subset : this.subsets) {
            size += subset.size();
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        return new CompositeCollectionItr();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompositeCollectionItr
    implements Iterator<E> {
        private final LinkedList<Iterator<? extends E>> itrs = new LinkedList();
        private Iterator<? extends E> currItr;

        public CompositeCollectionItr() {
            for (Collection subset : CompositeCollection.this.subsets) {
                this.itrs.add(subset.iterator());
            }
            this.currItr = this.itrs.getFirst();
        }

        @Override
        public boolean hasNext() {
            for (Iterator iterator : this.itrs) {
                if (!iterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.currItr.hasNext()) {
                this.itrs.poll();
                if (this.itrs.isEmpty()) {
                    throw new NoSuchElementException();
                }
                this.currItr = this.itrs.getFirst();
            }
            return this.currItr.next();
        }

        @Override
        public void remove() {
            this.currItr.remove();
        }
    }
}

