/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexComparator<T, C>
implements Comparator<C> {
    protected final Map<T, Integer> indexMap;

    public AbstractIndexComparator(List<T> list) {
        this(AbstractIndexComparator.createIndexMap(list));
    }

    public AbstractIndexComparator(Map<T, Integer> indexMap) {
        if (indexMap == null) {
            throw new NullPointerException();
        }
        this.indexMap = indexMap;
    }

    public Map<T, Integer> getIndexMap() {
        return this.indexMap;
    }

    public static <T> Map<T, Integer> createIndexMap(List<T> list) {
        HashMap<T, Integer> idxMap = new HashMap<T, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            idxMap.put(list.get(i), i);
        }
        return Collections.unmodifiableMap(idxMap);
    }
}

