/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.util;

import edu.mit.jmwe.util.ConfirmingJFileChooser;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSelector {
    private JFileChooser chooser;

    protected File getLocation(Class<?> key) {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        String path = node.get(key.getCanonicalName(), null);
        return path == null ? null : new File(path);
    }

    protected void setLocation(Class<?> key, File loc) {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        node.put(key.getCanonicalName(), loc.getAbsolutePath());
    }

    protected File chooseFile(String msg, Class<?> key) {
        return this.choose(msg, key, 0, 0);
    }

    protected File chooseFileForWriting(String msg, Class<?> key) {
        return this.choose(msg, key, 1, 0);
    }

    protected File chooseDirectory(String msg, Class<?> key) {
        return this.choose(msg, key, 0, 1);
    }

    protected File choose(String msg, Class<?> key, int dialogType, int selMode) {
        File location = this.getLocation(key);
        JFileChooser chooser = this.getFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setDialogType(dialogType);
        chooser.setFileSelectionMode(selMode);
        chooser.setSelectedFile(location);
        if (chooser.showDialog(null, null) != 0) {
            return null;
        }
        File result = chooser.getSelectedFile();
        this.setLocation(key, result);
        return result;
    }

    protected JFileChooser getFileChooser() {
        if (this.chooser == null) {
            this.chooser = new ConfirmingJFileChooser();
        }
        return this.chooser;
    }
}

