/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.index;

import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.index.InMemoryMWEIndex;
import edu.mit.jmwe.util.StreamAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEIndex
extends InMemoryMWEIndex {
    private final URL url;
    private final Iterable<String> origData;
    private final Map<IMWEDescID, ? extends IRootMWEDesc> origMap;

    public MWEIndex(String ... rootDescs) {
        this(Arrays.asList(rootDescs));
    }

    public MWEIndex(Iterable<String> origData) {
        if (origData == null) {
            throw new NullPointerException();
        }
        this.origData = origData;
        this.origMap = null;
        this.url = null;
    }

    public MWEIndex(Map<IMWEDescID, ? extends IRootMWEDesc> rootDescs) {
        if (rootDescs == null) {
            throw new NullPointerException();
        }
        this.origMap = rootDescs;
        this.origData = null;
        this.url = null;
    }

    public MWEIndex(File file) {
        this(StreamAdapter.toURL(file));
    }

    public MWEIndex(URL url) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.origMap = null;
        this.origData = null;
        this.url = url;
    }

    public URL getSource() {
        return this.url;
    }

    @Override
    protected Map<IMWEDescID, ? extends IRootMWEDesc> createData() throws IOException {
        if (this.origMap != null) {
            return this.origMap;
        }
        if (this.origData != null) {
            return MWEIndex.createData(this.origData);
        }
        InputStream is = this.url.openStream();
        InputStreamReader reader = new InputStreamReader(is);
        Map<IMWEDescID, IRootMWEDesc> result = MWEIndex.createData(reader);
        reader.close();
        is.close();
        return result;
    }
}

