/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.index;

import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.index.IMWEDescSet;
import edu.mit.jmwe.util.CompositeCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEDescSet
extends CompositeCollection<IMWEDesc>
implements IMWEDescSet {
    private boolean isUnmodifiable;
    private Set<IRootMWEDesc> rootDescs;
    private Set<IInfMWEDesc> infDescs;
    private static MWEDescSet emptySet;

    public MWEDescSet() {
        this((Set<IRootMWEDesc>)new TreeSet<IRootMWEDesc>(), (Set<IInfMWEDesc>)new TreeSet<IInfMWEDesc>());
    }

    public MWEDescSet(Set<IRootMWEDesc> rootDescs, Set<IInfMWEDesc> infDescs) {
        Collection[] collectionArray = new Collection[2];
        rootDescs = MWEDescSet.replaceNull(rootDescs);
        collectionArray[0] = rootDescs;
        infDescs = MWEDescSet.replaceNull(infDescs);
        collectionArray[1] = infDescs;
        super(collectionArray);
        this.isUnmodifiable = false;
        this.rootDescs = rootDescs;
        this.infDescs = infDescs;
    }

    @Override
    public Set<IRootMWEDesc> getRootMWEDescs() {
        return this.rootDescs;
    }

    @Override
    public Set<IInfMWEDesc> getInflectedMWEDescs() {
        return this.infDescs;
    }

    @Override
    public boolean add(IMWEDesc o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof IRootMWEDesc) {
            return this.rootDescs.add((IRootMWEDesc)o);
        }
        if (o instanceof IInfMWEDesc) {
            return this.infDescs.add((IInfMWEDesc)o);
        }
        throw new IllegalArgumentException(o.getClass().getCanonicalName() + " implements neither " + IRootMWEDesc.class.getCanonicalName() + " nor " + IInfMWEDesc.class.getCanonicalName());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IRootMWEDesc) {
            return this.rootDescs.remove((IRootMWEDesc)o);
        }
        if (o instanceof IInfMWEDesc) {
            return this.infDescs.remove((IInfMWEDesc)o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object e : c) {
            result |= this.remove(e);
        }
        return result;
    }

    @Override
    public void makeUnmodifiable() {
        if (this.isUnmodifiable) {
            return;
        }
        this.rootDescs = MWEDescSet.makeUnmodifiable(this.rootDescs);
        this.infDescs = MWEDescSet.makeUnmodifiable(this.infDescs);
        this.isUnmodifiable = true;
    }

    public static IMWEDescSet emptySet() {
        if (emptySet == null) {
            emptySet = new MWEDescSet();
            emptySet.makeUnmodifiable();
        }
        return emptySet;
    }

    public static <E extends IMWEDesc> Set<E> makeUnmodifiable(Set<E> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new TreeSet<E>(set));
    }

    public static <E extends IMWEDesc> Set<E> replaceNull(Set<E> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }
}

