/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.index;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.InfMWEDesc;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEDescID;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.data.RootMWEDesc;
import edu.mit.jmwe.data.concordance.IConcordanceSentence;
import edu.mit.jmwe.data.concordance.IConcordanceToken;
import edu.mit.jmwe.data.concordance.TaggedConcordanceIterator;
import edu.mit.jmwe.detect.Consecutive;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.InflectionRule;
import edu.mit.jmwe.harness.ConcordanceAnswerKey;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.index.MWEIndex;
import edu.mit.jmwe.util.AbstractFileSelector;
import edu.mit.jmwe.util.JWIPOS;
import edu.mit.jmwe.util.ProgressBar;
import edu.mit.jmwe.util.StreamAdapter;
import edu.mit.jsemcor.element.ISemanticTag;
import edu.mit.jsemcor.main.IConcordance;
import edu.mit.jsemcor.main.IConcordanceSet;
import edu.mit.jsemcor.main.Semcor;
import edu.mit.jwi.Dictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.POS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexBuilder
extends AbstractFileSelector
implements Runnable {
    public static void main(String[] args) {
        IndexBuilder builder = new IndexBuilder();
        builder.run();
    }

    @Override
    public void run() {
        File indexFile;
        IDictionary dict = this.getDictionary();
        if (dict == null) {
            return;
        }
        IConcordanceSet semcor = this.getConcordance();
        Iterable<IConcordanceSentence> itr = this.getTaggedIterator();
        File descFile = this.getDataFile();
        if (descFile == null) {
            return;
        }
        while (descFile.equals(indexFile = this.getIndexFile())) {
        }
        try {
            this.process(dict, itr, semcor, descFile, indexFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected IDictionary getDictionary() {
        File dir = this.getDictionaryDir();
        if (dir == null) {
            return null;
        }
        Dictionary wordnet = new Dictionary(StreamAdapter.toURL(dir));
        if (!wordnet.open()) {
            throw new IllegalStateException("Unable to open Wordnet");
        }
        return wordnet;
    }

    protected File getDictionaryDir() {
        return this.chooseDirectory("Select Wordnet Directory", IDictionary.class);
    }

    protected IConcordanceSet getConcordance() {
        File dir = this.getConcordanceDir();
        if (dir == null) {
            return null;
        }
        Semcor semcor = new Semcor(StreamAdapter.toURL(dir));
        if (!semcor.open()) {
            throw new IllegalStateException("Unable to open Semcor");
        }
        return semcor;
    }

    protected File getConcordanceDir() {
        return this.chooseDirectory("Select Semcor Directory (choose Cancel for no inflected forms or counts)", IConcordanceSet.class);
    }

    protected Iterable<IConcordanceSentence> getTaggedIterator() {
        final File file = this.getTaggedConcordanceFile();
        if (file == null) {
            return null;
        }
        return new Iterable<IConcordanceSentence>(){

            @Override
            public Iterator<IConcordanceSentence> iterator() {
                try {
                    return new TaggedConcordanceIterator(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    protected File getTaggedConcordanceFile() {
        return this.chooseFile("Select Tagged Semcor File (choose Cancel for no inflected forms or counts)", TaggedConcordanceIterator.class);
    }

    protected File getDataFile() {
        return this.chooseFileForWriting("Select MWEIndex Data File", IMWEDesc.class);
    }

    protected File getIndexFile() {
        return this.chooseFileForWriting("Select MWEIndex Index File (choose Cancel for no index file)", IMWEIndex.class);
    }

    protected List<String> getDataHeaderLines() {
        LinkedList<String> header = new LinkedList<String>();
        header.add("jMWE MWE Description Data File");
        header.add("Generated on " + new Date().toString());
        return header;
    }

    protected List<String> getIndexHeaderLines() {
        LinkedList<String> header = new LinkedList<String>();
        header.add("jMWE MWE Description Index File");
        header.add("Generated on " + new Date().toString());
        return header;
    }

    public void process(IDictionary dict, Iterable<? extends IConcordanceSentence> itr, IConcordanceSet cs, File dataFile, File indexFile) throws IOException {
        if (dict == null) {
            throw new NullPointerException();
        }
        if (dataFile == null) {
            throw new NullPointerException();
        }
        System.out.print("(1 of 5) Extracting MWEs from dictionary...");
        Map<IMWEDescID, MutableRootMWEDesc> data = this.extractMWEs(dict);
        System.out.println("done.");
        MWEIndex index = null;
        if (cs == null) {
            System.out.println("\nSkipping steps 2-4 because no concordance was provided");
        } else {
            int sentCnt = this.getEstimatedSentenceCount();
            ConcordanceAnswerKey key = new ConcordanceAnswerKey((Map<String, IConcordance>)cs);
            key.setIgnoreProperNouns(true);
            System.out.println("\n(2 of 5) Finding missing MWEs...");
            TreeSet<MutableRootMWEDesc> missing = new TreeSet<MutableRootMWEDesc>();
            ProgressBar pb = new ProgressBar(sentCnt);
            sentCnt = 0;
            for (IConcordanceSentence iConcordanceSentence : itr) {
                ++sentCnt;
                this.findMissingMWEs(key.getAnswers(iConcordanceSentence), data, missing);
                pb.increment();
            }
            pb.finish();
            System.out.println("Found " + missing.size() + " missing MWE entries in concordances.");
            System.out.println("\n(3 of 5) Counting marked occurences...");
            pb = new ProgressBar(sentCnt);
            for (IConcordanceSentence iConcordanceSentence : itr) {
                this.countMarked(key.getAnswers(iConcordanceSentence), data);
                pb.increment();
            }
            pb.finish();
            index = new MWEIndex(data);
            index.open();
            System.out.println("\n(4 of 5) Counting unmarked occurences...");
            pb = new ProgressBar(sentCnt);
            IMWEDetector d = this.getUmarkedDetector(index);
            for (IConcordanceSentence iConcordanceSentence : itr) {
                this.countUnmarked(d, iConcordanceSentence, key.getAnswers(iConcordanceSentence));
                pb.increment();
            }
            pb.finish();
        }
        if (index == null) {
            index = new MWEIndex(data);
        }
        System.out.print("\n(5 of 5) Writing file(s)...");
        dataFile = IndexBuilder.deleteFile(dataFile, new FileGetter(){

            public File get() {
                return IndexBuilder.this.getDataFile();
            }
        });
        if (dataFile != null) {
            IndexBuilder.writeDataFile(index, new FileOutputStream(dataFile), this.getDataHeaderLines());
        }
        System.out.println("done.");
        this.printTotals(data);
    }

    protected int getEstimatedSentenceCount() {
        return 20138;
    }

    public Map<IMWEDescID, MutableRootMWEDesc> extractMWEs(IDictionary dict) {
        TreeMap<IMWEDescID, MutableRootMWEDesc> result = new TreeMap<IMWEDescID, MutableRootMWEDesc>();
        for (POS pos : POS.values()) {
            MWEPOS mwepos = JWIPOS.toMWEPOS(pos);
            Iterator itr = dict.getIndexWordIterator(pos);
            while (itr.hasNext()) {
                IIndexWord idxWord = (IIndexWord)itr.next();
                if (!this.isMWE(idxWord)) continue;
                MutableRootMWEDesc desc = new MutableRootMWEDesc(idxWord.getLemma(), mwepos);
                result.put(desc.getID(), desc);
            }
        }
        return result;
    }

    protected boolean isMWE(IIndexWord idxWord) {
        return idxWord.getLemma().indexOf(95) > -1;
    }

    public void countMarked(List<IMWE<IConcordanceToken>> answers, Map<IMWEDescID, MutableRootMWEDesc> index) {
        if (index == null) {
            throw new NullPointerException();
        }
        for (IMWE<IConcordanceToken> mwe : answers) {
            AbstractMWEDesc targetDesc;
            MutableRootMWEDesc rootDesc = index.get(mwe.getEntry().getID());
            if (mwe.isInflected()) {
                MutableInfMWEDesc infDesc = this.getInflectedForm(rootDesc, mwe.getForm());
                targetDesc = infDesc;
                if (InflectionRule.isInflectedByPattern(mwe)) {
                    infDesc.incrementMarkedPattern();
                }
            } else {
                targetDesc = rootDesc;
            }
            if (this.isSplit(mwe)) {
                targetDesc.incrementMarkedSplit();
                continue;
            }
            targetDesc.incrementMarkedContinuous();
        }
    }

    protected MutableInfMWEDesc getInflectedForm(MutableRootMWEDesc root, String form) {
        for (MutableInfMWEDesc infDesc : root.getInflected().values()) {
            if (!infDesc.getForm().equals(form)) continue;
            return infDesc;
        }
        MutableInfMWEDesc infDesc = new MutableInfMWEDesc((IRootMWEDesc)root, form);
        root.getInflected().put(infDesc.getForm(), infDesc);
        return infDesc;
    }

    protected <T extends IConcordanceToken> boolean isSplit(IMWE<T> mwe) {
        int tokenNum = ((IConcordanceToken)mwe.getTokens().get(0)).getTokenNumber();
        for (IConcordanceToken token : mwe.getTokens()) {
            if (token.getTokenNumber() == tokenNum) continue;
            return true;
        }
        return false;
    }

    public <T extends IToken> void findMissingMWEs(List<IMWE<T>> mwes, Map<IMWEDescID, MutableRootMWEDesc> index, Set<MutableRootMWEDesc> missing) {
        for (IMWE<T> mwe : mwes) {
            MutableRootMWEDesc rootDesc;
            if (mwe.getEntry().getPOS() == MWEPOS.PROPER_NOUN || (rootDesc = index.get(mwe.getEntry().getID())) != null) continue;
            rootDesc = new MutableRootMWEDesc(mwe.getEntry().getForm(), mwe.getEntry().getPOS());
            index.put(rootDesc.getID(), rootDesc);
            if (!mwe.getForm().equals(mwe.getEntry().getForm())) {
                MutableInfMWEDesc infDesc = new MutableInfMWEDesc((IRootMWEDesc)rootDesc, mwe.getForm());
                rootDesc.getInflected().put(infDesc.getForm(), infDesc);
            }
            if (missing == null) continue;
            missing.add(rootDesc);
        }
    }

    protected IMWEDetector getUmarkedDetector(IMWEIndex index) {
        return new Consecutive(index){

            @Override
            protected Set<? extends IMWEDesc> getMWEDescs(IToken token) {
                IMWEIndex index = this.getMWEIndex();
                HashSet<IMWEDesc> result = new HashSet<IMWEDesc>();
                result.addAll(index.getAll(token.getForm().toLowerCase()));
                if (token.getStems() != null) {
                    for (String stem : token.getStems()) {
                        result.addAll(index.getAll(stem.toLowerCase()));
                    }
                }
                return result;
            }
        };
    }

    public void countUnmarked(IMWEDetector detector, IConcordanceSentence sent, List<IMWE<IConcordanceToken>> answers) {
        List<IMWE<IConcordanceToken>> found = detector.detect(sent);
        for (IMWE<IConcordanceToken> mwe : found) {
            if (this.contains(answers, mwe)) continue;
            if (mwe.getEntry() instanceof MutableRootMWEDesc) {
                MutableRootMWEDesc rootDesc = (MutableRootMWEDesc)mwe.getEntry();
                if (mwe.isInflected()) {
                    if (rootDesc.getInflected().get(mwe.getForm()) != null) continue;
                    rootDesc.incrementUnmarkedInflected();
                    if (!InflectionRule.isInflectedByPattern(mwe)) continue;
                    rootDesc.incrementUnmarkedPattern();
                    continue;
                }
                rootDesc.incrementUnmarkedExact();
                continue;
            }
            if (mwe.getEntry() instanceof MutableInfMWEDesc) {
                MutableInfMWEDesc infDesc = (MutableInfMWEDesc)mwe.getEntry();
                if (mwe.isInflected()) {
                    throw new IllegalStateException();
                }
                infDesc.incrementUnmarkedExact();
                if (!InflectionRule.isInflectedByPattern(mwe)) continue;
                infDesc.incrementUnmarkedPattern();
                continue;
            }
            throw new IllegalStateException();
        }
    }

    protected boolean contains(List<IMWE<IConcordanceToken>> list, IMWE<IConcordanceToken> mwe) {
        for (IMWE<IConcordanceToken> answer : list) {
            if (!MWE.equals(answer, mwe)) continue;
            return true;
        }
        return false;
    }

    public void printTotals(Map<IMWEDescID, MutableRootMWEDesc> entries) {
        int[] counts = new int[6];
        int numRoots = 0;
        int numInfs = 0;
        for (MutableRootMWEDesc baseForm : entries.values()) {
            counts[0] = counts[0] + baseForm.getMarkedContinuous();
            counts[1] = counts[1] + baseForm.getMarkedSplit();
            counts[2] = counts[2] + baseForm.getUnmarkedExact();
            counts[3] = counts[3] + baseForm.getUnmarkedPattern();
            counts[4] = counts[4] + baseForm.getUnmarkedInflected();
            ++numRoots;
            for (MutableInfMWEDesc infForm : baseForm.getInflected().values()) {
                counts[0] = counts[0] + infForm.getMarkedContinuous();
                counts[1] = counts[1] + infForm.getMarkedSplit();
                counts[2] = counts[2] + infForm.getUnmarkedExact();
                counts[3] = counts[3] + infForm.getUnmarkedPattern();
                counts[5] = counts[5] + infForm.getMarkedPattern();
                ++numInfs;
            }
        }
        System.out.println("Marked Continuous  : " + counts[0]);
        System.out.println("Marked Split       : " + counts[1]);
        System.out.println("Unmarked Exact     : " + counts[2]);
        System.out.println("Unmarked Pattern   : " + counts[3]);
        System.out.println("Unmarked Inflected : " + counts[4]);
        System.out.println("Marked Pattern     : " + counts[5]);
        System.out.println("RootMWEDescs    : " + numRoots);
        System.out.println("InfMWEDEsc      : " + numInfs);
    }

    public static void writeDataFile(IMWEIndex index, OutputStream out, Iterable<String> headerLines) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
        if (headerLines != null) {
            for (String line : headerLines) {
                if (line.indexOf(10) > -1) {
                    throw new IllegalArgumentException("Illegal newline character in header line: " + line);
                }
                if (line.indexOf(13) <= -1) continue;
                throw new IllegalArgumentException("Illegal carriage return character in header line: " + line);
            }
            for (String line : headerLines) {
                w.append("// ");
                w.append(line);
                w.append('\n');
            }
        }
        Iterator<IRootMWEDesc> i = index.getRootIterator();
        while (i.hasNext()) {
            RootMWEDesc.toString(i.next(), (Appendable)w);
            w.append('\n');
        }
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    public static void writeIndexFile(IMWEIndex index, OutputStream out, Iterable<String> headerLines) throws IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out));
        if (headerLines != null) {
            for (String line : headerLines) {
                if (line.indexOf(10) > -1) {
                    throw new IllegalArgumentException("Illegal newline character in header line: " + line);
                }
                if (line.indexOf(13) <= -1) continue;
                throw new IllegalArgumentException("Illegal carriage return character in header line: " + line);
            }
            for (String line : headerLines) {
                w.append("// ");
                w.append(line);
                w.append('\n');
            }
        }
        Iterator<String> keyItr = index.getIndexIterator();
        while (keyItr.hasNext()) {
            String key = keyItr.next();
            w.append(key);
            for (IMWEDesc iMWEDesc : index.getAll(key)) {
                w.append(' ');
                MWEDescID.toString(iMWEDesc.getID(), w);
            }
            w.append('\n');
        }
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    public static File deleteFile(File file, FileGetter fg) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return file;
        }
        if (file.delete()) {
            return file;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Unable to delete the following file:\n");
        msg.append(file.getAbsolutePath());
        msg.append("\nPlease select another file in the next dialog.");
        JOptionPane.showMessageDialog(null, msg.toString(), "Overwrite Failed", 0);
        return IndexBuilder.deleteFile(fg.get(), fg);
    }

    public static MWEPOS toMWEPOS(ISemanticTag tag) {
        String lexsn = (String)tag.getLexicalSense().get(0);
        int pos = Integer.parseInt(lexsn.substring(0, 1));
        switch (pos) {
            case 1: {
                return MWEPOS.NOUN;
            }
            case 2: {
                return MWEPOS.VERB;
            }
            case 3: {
                return MWEPOS.ADJECTIVE;
            }
            case 4: {
                return MWEPOS.ADVERB;
            }
            case 5: {
                return MWEPOS.ADJECTIVE;
            }
        }
        throw new IllegalStateException();
    }

    public static class MutableInfMWEDesc
    extends InfMWEDesc
    implements IMutableMWEDesc {
        public MutableInfMWEDesc(IRootMWEDesc root, String inflectedForm) {
            super(root, inflectedForm);
        }

        public void incrementMarkedContinuous() {
            this.counts[0] = this.counts[0] + 1;
        }

        public void incrementMarkedSplit() {
            this.counts[1] = this.counts[1] + 1;
        }

        public void incrementUnmarkedExact() {
            this.counts[2] = this.counts[2] + 1;
        }

        public void incrementUnmarkedPattern() {
            this.counts[3] = this.counts[3] + 1;
        }

        public void incrementMarkedPattern() {
            this.counts[4] = this.counts[4] + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MutableRootMWEDesc
    extends RootMWEDesc
    implements IMutableMWEDesc {
        private Map<String, MutableInfMWEDesc> infForms = new TreeMap<String, MutableInfMWEDesc>();

        public MutableRootMWEDesc(String surfaceForm, MWEPOS pos) {
            super(surfaceForm, pos);
        }

        @Override
        public void incrementMarkedContinuous() {
            this.counts[0] = this.counts[0] + 1;
        }

        @Override
        public void incrementMarkedSplit() {
            this.counts[1] = this.counts[1] + 1;
        }

        @Override
        public void incrementUnmarkedExact() {
            this.counts[2] = this.counts[2] + 1;
        }

        @Override
        public void incrementUnmarkedPattern() {
            this.counts[3] = this.counts[3] + 1;
        }

        public void incrementUnmarkedInflected() {
            this.counts[4] = this.counts[4] + 1;
        }

        public Map<String, MutableInfMWEDesc> getInflected() {
            return this.infForms;
        }
    }

    public static interface IMutableMWEDesc
    extends IMWEDesc {
        public void incrementMarkedContinuous();

        public void incrementMarkedSplit();

        public void incrementUnmarkedExact();

        public void incrementUnmarkedPattern();
    }

    public static interface FileGetter {
        public File get();
    }
}

