/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.index;

import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IMWEDescID;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.MWEDescID;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.data.RootMWEDesc;
import edu.mit.jmwe.index.IMWEDescSet;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.index.MWEDescSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InMemoryMWEIndex
implements IMWEIndex {
    protected final Lock lifecycleLock = new ReentrantLock();
    private Map<IMWEDescID, ? extends IRootMWEDesc> data;
    private Map<String, ? extends IMWEDescSet> index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        try {
            this.lifecycleLock.lock();
            if (this.isOpen()) {
                boolean bl = true;
                return bl;
            }
            Map<IMWEDescID, ? extends IRootMWEDesc> dat = this.createData();
            if (dat.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Map<String, ? extends IMWEDescSet> idx = this.createIndex(dat);
            this.data = dat;
            this.index = idx;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected abstract Map<IMWEDescID, ? extends IRootMWEDesc> createData() throws IOException;

    protected Map<String, ? extends IMWEDescSet> createIndex(Map<IMWEDescID, ? extends IRootMWEDesc> data) {
        TreeMap<String, IMWEDescSet> index = new TreeMap<String, IMWEDescSet>();
        for (Map.Entry<IMWEDescID, ? extends IRootMWEDesc> entry : data.entrySet()) {
            for (IRootMWEDesc.IRootPart iRootPart : entry.getValue().getParts()) {
                this.insert(iRootPart.getForm(), entry.getValue(), index);
            }
            for (IInfMWEDesc iInfMWEDesc : entry.getValue().getInflected().values()) {
                for (IInfMWEDesc.IInfPart iInfPart : iInfMWEDesc.getParts()) {
                    this.insert(iInfPart.getForm(), iInfMWEDesc, index);
                }
            }
        }
        for (Map.Entry<IMWEDescID, IRootMWEDesc> entry : index.entrySet()) {
            ((IMWEDescSet)((Object)entry.getValue())).makeUnmodifiable();
        }
        return Collections.unmodifiableMap(index);
    }

    protected final void insert(String key, IMWEDesc object, Map<String, IMWEDescSet> map) {
        IMWEDescSet set = map.get(key);
        if (set == null) {
            set = new MWEDescSet();
            map.put(key, set);
        }
        set.add(object);
    }

    @Override
    public boolean isOpen() {
        try {
            this.lifecycleLock.lock();
            boolean bl = this.data != null;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lifecycleLock.lock();
            if (this.isOpen()) {
                this.data = null;
                this.index = null;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public IMWEDesc get(IMWEDescID id) {
        IMWEDescID rootID = id.getRootID();
        IRootMWEDesc rootDesc = this.data.get(rootID);
        if (rootDesc == null || rootID == id) {
            return rootDesc;
        }
        return rootDesc.getInflected().get(id.getInflectedForm());
    }

    @Override
    public IRootMWEDesc getRootMWEDesc(String lemma, MWEPOS pos) {
        return this.data.get(new MWEDescID(lemma, pos));
    }

    @Override
    public IInfMWEDesc getInflectedMWEDesc(String lemma, MWEPOS pos, String inflected) {
        IRootMWEDesc root = this.getRootMWEDesc(lemma, pos);
        if (root == null) {
            return null;
        }
        return root.getInflected().get(inflected.trim().toLowerCase());
    }

    @Override
    public Set<? extends IRootMWEDesc> get(String part) {
        IMWEDescSet all = this.getAll(part);
        return all.getRootMWEDescs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMWEDescSet getAll(String part) {
        try {
            this.lifecycleLock.lock();
            this.checkOpen();
            if (part.indexOf(95) > -1) {
                throw new IllegalArgumentException();
            }
            IMWEDescSet entries = this.index.get(part.toLowerCase());
            IMWEDescSet iMWEDescSet = entries == null ? MWEDescSet.emptySet() : entries;
            return iMWEDescSet;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public Iterator<IRootMWEDesc> getRootIterator() {
        return this.data.values().iterator();
    }

    @Override
    public Iterator<String> getIndexIterator() {
        return this.index.keySet().iterator();
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("index is closed");
        }
    }

    public static boolean isComment(String descStr) {
        if (descStr.startsWith("//")) {
            return true;
        }
        return descStr.startsWith(";;");
    }

    public static Map<IMWEDescID, IRootMWEDesc> createData(Iterable<String> descStrs) {
        TreeMap<IMWEDescID, IRootMWEDesc> result = new TreeMap<IMWEDescID, IRootMWEDesc>();
        for (String descStr : descStrs) {
            if ((descStr = descStr.trim()).length() == 0 || InMemoryMWEIndex.isComment(descStr)) continue;
            IRootMWEDesc rootDesc = RootMWEDesc.parse(descStr);
            result.put(rootDesc.getID(), rootDesc);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<IMWEDescID, IRootMWEDesc> createData(Reader r) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        TreeMap<IMWEDescID, IRootMWEDesc> result = new TreeMap<IMWEDescID, IRootMWEDesc>();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || InMemoryMWEIndex.isComment(line)) continue;
            IRootMWEDesc rootDesc = RootMWEDesc.parse(line);
            result.put(rootDesc.getID(), rootDesc);
        }
        return Collections.unmodifiableMap(result);
    }
}

