/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedPNoun
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.UntaggedPNoun";
    private static UntaggedPNoun instance = null;

    public static UntaggedPNoun getInstance() {
        if (instance == null) {
            instance = new UntaggedPNoun();
        }
        return instance;
    }

    protected UntaggedPNoun() {
        super(ID);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList mwes = new ArrayList();
        block0: for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!mwe.getEntry().getPOS().equals((Object)MWEPOS.PROPER_NOUN)) continue;
            for (IToken token : mwe.getTokens()) {
                if (MWEPOS.toMWEPOS(token.getTag()) == MWEPOS.PROPER_NOUN) continue;
                mwes.add(mwe);
                continue block0;
            }
        }
        return new ErrorResult(this.getID(), mwes);
    }
}

