/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.InOrder;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfOrder
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.OutOfOrder";
    private static OutOfOrder instance = null;

    public static OutOfOrder getInstance() {
        if (instance == null) {
            instance = new OutOfOrder();
        }
        return instance;
    }

    protected OutOfOrder() {
        super(ID);
    }

    public <T extends IToken, U extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, U> result) {
        HashMap details = new HashMap(3);
        LinkedList<IMWE<T>> problems = new LinkedList<IMWE<T>>();
        for (IMWE<T> mwe : result.getFalsePositives()) {
            if (!InOrder.isOutOfOrder(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalsePos", new ArrayList(problems));
        problems = new LinkedList();
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!InOrder.isOutOfOrder(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        problems = new LinkedList();
        for (IMWE<T> mwe : result.getTruePositives()) {
            if (!InOrder.isOutOfOrder(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".TruePos", new ArrayList(problems));
        problems.clear();
        return new ErrorResult(details);
    }
}

