/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import edu.mit.jmwe.index.IMWEIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingFromIndex
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.Miss";
    protected final IMWEIndex index;

    public MissingFromIndex(IMWEIndex index) {
        super(ID);
        if (index == null) {
            throw new NullPointerException();
        }
        this.index = index;
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList<IMWE<T>> problems = new ArrayList<IMWE<T>>();
        HashMap map = new HashMap(6);
        for (MWEPOS pos : MWEPOS.values()) {
            map.put(pos, new ArrayList());
        }
        HashMap details = new HashMap(3);
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!MissingFromIndex.isProblem(mwe, this.index)) continue;
            problems.add(mwe);
            ((List)map.get((Object)mwe.getEntry().getPOS())).add(mwe);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        for (MWEPOS pos : MWEPOS.values()) {
            details.put(this.getID() + "." + pos.getIdentifier(), map.get((Object)pos));
        }
        return new ErrorResult(details);
    }

    public static <T extends IToken> boolean isProblem(IMWE<T> mwe, IMWEIndex index) {
        IMWEDesc desc = mwe.getEntry();
        for (IMWEDesc.IPart iPart : desc.getParts()) {
            if (!index.get(iPart.getForm()).contains(desc)) continue;
            return false;
        }
        for (IToken iToken : mwe.getPartMap().keySet()) {
            if (index.get(iToken.getForm().toLowerCase()).contains(desc)) {
                return false;
            }
            if (iToken.getStems() == null) continue;
            for (String stem : iToken.getStems()) {
                if (!index.get(stem).contains(desc)) continue;
                return false;
            }
        }
        return true;
    }
}

