/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.Continuous;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import edu.mit.jmwe.util.ListComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterstitialTokens
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.Interstitial";
    private static InterstitialTokens instance = null;

    public static InterstitialTokens getInstance() {
        if (instance == null) {
            instance = new InterstitialTokens();
        }
        return instance;
    }

    protected InterstitialTokens() {
        super(ID);
    }

    public <T extends IToken, U extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, U> result) {
        if (result.getSentence() == null) {
            Map details = Collections.emptyMap();
            return new ErrorResult(details);
        }
        HashMap details = new HashMap(3);
        Map indexMap = ListComparator.createIndexMap(result.getSentence());
        LinkedList<IMWE> problems = new LinkedList<IMWE>();
        for (IMWE<T> iMWE : result.getFalsePositives()) {
            if (!Continuous.isDiscontinuous(iMWE, indexMap)) continue;
            problems.add(iMWE);
        }
        details.put(this.getID() + ".FalsePos", new ArrayList(problems));
        Iterator<Object> i = problems.iterator();
        while (i.hasNext()) {
            if (InterstitialTokens.hasParticle((IMWE)i.next(), result.getSentence())) continue;
            i.remove();
        }
        details.put(this.getID() + ".FalsePos" + ".Particle", new ArrayList(problems));
        problems = new LinkedList();
        for (IMWE iMWE : result.getFalseNegatives()) {
            if (!Continuous.isDiscontinuous(iMWE, indexMap)) continue;
            problems.add(iMWE);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        i = problems.iterator();
        while (i.hasNext()) {
            if (InterstitialTokens.hasParticle((IMWE)i.next(), result.getSentence())) continue;
            i.remove();
        }
        details.put(this.getID() + ".FalseNeg" + ".Particle", new ArrayList(problems));
        problems = new LinkedList();
        for (IMWE iMWE : result.getTruePositives()) {
            if (!Continuous.isDiscontinuous(iMWE, indexMap)) continue;
            problems.add(iMWE);
        }
        details.put(this.getID() + ".TruePos", new ArrayList(problems));
        i = problems.iterator();
        while (i.hasNext()) {
            if (InterstitialTokens.hasParticle((IMWE)i.next(), result.getSentence())) continue;
            i.remove();
        }
        details.put(this.getID() + ".TruePos" + ".Particle", new ArrayList(problems));
        return new ErrorResult(details);
    }

    public static <T extends IToken> boolean isParticle(T token) {
        String tag = token.getTag();
        return tag.equals("RP") || tag.equals("TO");
    }

    public static <T extends IToken> boolean hasParticle(IMWE<T> mwe, List<T> sentence) {
        IToken last = (IToken)mwe.getTokens().get(0);
        for (IToken curr : mwe.getTokens()) {
            if (sentence.indexOf(curr) > sentence.indexOf(last) + 1 && InterstitialTokens.isParticle(curr)) {
                return true;
            }
            last = curr;
        }
        return false;
    }
}

