/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.InflectionRule;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflectionPatternError
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.PAT";
    private static InflectionPatternError instance = null;

    public static InflectionPatternError getInstance() {
        if (instance == null) {
            instance = new InflectionPatternError();
        }
        return instance;
    }

    protected InflectionPatternError() {
        super(ID);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList<IMWE<T>> problems = new ArrayList<IMWE<T>>();
        HashMap details = new HashMap(3);
        for (IMWE<T> mwe : result.getFalsePositives()) {
            if (!mwe.isInflected() || !InflectionRule.isInflectedByPattern(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalsePos", new ArrayList(problems));
        problems.clear();
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!mwe.isInflected() || !InflectionRule.isInflectedByPattern(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        problems.clear();
        for (IMWE<T> mwe : result.getTruePositives()) {
            if (!mwe.isInflected() || !InflectionRule.isInflectedByPattern(mwe)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".TruePos", new ArrayList(problems));
        problems.clear();
        return new ErrorResult(details);
    }
}

