/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflectionError
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.Inflection";
    private static InflectionError instance = null;

    public static InflectionError getInstance() {
        if (instance == null) {
            instance = new InflectionError();
        }
        return instance;
    }

    protected InflectionError() {
        super(ID);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        HashMap details = new HashMap(3);
        LinkedList<IMWE<T>> problems = new LinkedList<IMWE<T>>();
        for (IMWE<T> mwe : result.getFalsePositives()) {
            if (!mwe.isInflected()) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalsePos", new ArrayList(problems));
        problems = new LinkedList();
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!mwe.isInflected()) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        problems.clear();
        problems = new LinkedList();
        for (IMWE<T> mwe : result.getTruePositives()) {
            if (!mwe.isInflected()) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".TruePos", new ArrayList(problems));
        return new ErrorResult(details);
    }
}

