/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPrep
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.ExtraPrep";
    private static ExtraPrep instance = null;

    public static ExtraPrep getInstance() {
        if (instance == null) {
            instance = new ExtraPrep();
        }
        return instance;
    }

    protected ExtraPrep() {
        super(ID);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList<IMWE<T>> mwes = new ArrayList<IMWE<T>>();
        IMWE<T> test = null;
        for (IMWE<T> fn : result.getFalseNegatives()) {
            if (!fn.getEntry().getPOS().equals((Object)MWEPOS.PROPER_NOUN)) continue;
            for (IMWE<T> fp : result.getFalsePositives()) {
                if (!fp.getEntry().getPOS().equals((Object)MWEPOS.PROPER_NOUN) || !(MWE.overlap(fp, fn) > 0.0)) continue;
                test = fp;
                break;
            }
            if (test == null) continue;
            if (test.getTokens().size() < fn.getTokens().size() && ExtraPrep.findTag(test, "IN") == -1 && ExtraPrep.findTag(fn, "IN") != -1) {
                mwes.add(test);
            }
            test = null;
        }
        HashMap details = new HashMap();
        details.put(this.getID(), mwes);
        return new ErrorResult(details);
    }

    protected static <T extends IToken> int findTag(IMWE<T> test, String tag) {
        int i = 0;
        for (IToken token : test.getTokens()) {
            if (token.getTag().equalsIgnoreCase(tag)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

