/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.SentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorDisagreement
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.Disagree";
    protected final IMWEDetector d;

    public DetectorDisagreement(IMWEDetector d) {
        super(ID);
        if (d == null) {
            throw new NullPointerException();
        }
        this.d = d;
    }

    public IMWEDetector getDetector() {
        return this.d;
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList<IMWE<T>> problems = new ArrayList<IMWE<T>>();
        HashMap details = new HashMap(3);
        for (IMWE<T> mwe : result.getFalsePositives()) {
            if (!DetectorDisagreement.isProblem(mwe, result, this.d)) continue;
            System.out.println(mwe);
            System.out.println(SentenceResult.toString(result, result.getSentence()));
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalsePos", new ArrayList(problems));
        problems.clear();
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!DetectorDisagreement.isProblem(mwe, result, this.d)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".FalseNeg", new ArrayList(problems));
        problems.clear();
        for (IMWE<T> mwe : result.getTruePositives()) {
            if (!DetectorDisagreement.isProblem(mwe, result, this.d)) continue;
            problems.add(mwe);
        }
        details.put(this.getID() + ".TruePos", new ArrayList(problems));
        return new ErrorResult(details);
    }

    public static <T extends IToken, S extends IMarkedSentence<T>> boolean isProblem(IMWE<T> mwe, ISentenceResult<T, S> result, IMWEDetector detector) {
        List found = detector.detect(result.getSentence());
        return !found.contains(mwe);
    }
}

