/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.IErrorDetector;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeErrorDetector
extends AbstractList<IErrorDetector>
implements IErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.composite";
    private final IErrorDetector[] backingArray;

    public CompositeErrorDetector(IErrorDetector ... detectors) {
        this(Arrays.asList(detectors));
    }

    public CompositeErrorDetector(List<? extends IErrorDetector> detectors) {
        if (detectors.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.backingArray = new IErrorDetector[detectors.size()];
        int i = 0;
        for (IErrorDetector iErrorDetector : detectors) {
            if (iErrorDetector == null) {
                throw new NullPointerException();
            }
            this.backingArray[i++] = iErrorDetector;
        }
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ErrorResult.ErrorResultBuilder<T> builder = new ErrorResult.ErrorResultBuilder<T>();
        for (IErrorDetector d : this.backingArray) {
            builder.addDetail(d.detect(result));
        }
        return builder.create();
    }

    @Override
    public IErrorDetector get(int index) {
        return this.backingArray[index];
    }

    @Override
    public int size() {
        return this.backingArray.length;
    }
}

