/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result.error;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.StopWords;
import edu.mit.jmwe.harness.result.ErrorResult;
import edu.mit.jmwe.harness.result.IErrorResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.error.AbstractErrorDetector;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllStopWords
extends AbstractErrorDetector {
    public static final String ID = "edu.mit.jmwe.error.AllStopWords";
    private static AllStopWords instance = null;

    public static AllStopWords getInstance() {
        if (instance == null) {
            instance = new AllStopWords();
        }
        return instance;
    }

    protected AllStopWords() {
        super(ID);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> IErrorResult<T> detect(ISentenceResult<T, S> result) {
        ArrayList mwes = new ArrayList();
        for (IMWE<T> mwe : result.getFalseNegatives()) {
            if (!StopWords.hasAllStopWords(mwe.getEntry().getParts())) continue;
            mwes.add(mwe);
        }
        return new ErrorResult(this.getID(), mwes);
    }
}

