/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.MWEResultBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenResultBuilder<T extends IToken, U extends IMarkedSentence<T>>
extends MWEResultBuilder<T, U> {
    @Override
    public void process(List<IMWE<T>> found, List<IMWE<T>> answers) {
        MWEPOS pos;
        HashSet<IMWE<T>> truePos = new HashSet<IMWE<T>>();
        for (IMWE<T> mwe : found) {
            for (IToken token : mwe.getTokens()) {
                pos = MWEPOS.toMWEPOS(token.getTag());
                ((AtomicInteger)this.foundData.get((Object)pos)).incrementAndGet();
                if (!answers.contains(mwe)) continue;
                if (!truePos.contains(mwe)) {
                    truePos.add(mwe);
                }
                ((AtomicInteger)this.correctData.get((Object)pos)).incrementAndGet();
            }
        }
        for (IMWE<T> amwe : answers) {
            for (IToken token : amwe.getTokens()) {
                pos = MWEPOS.toMWEPOS(token.getTag());
                ((AtomicInteger)this.answerData.get((Object)pos)).incrementAndGet();
            }
        }
    }
}

