/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.MWEResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceResult<T extends IToken, S extends IMarkedSentence<T>>
implements ISentenceResult<T, S> {
    private final S sentence;
    private double precision;
    private double recall;
    private double fscore;
    private final List<IMWE<T>> answers;
    private final List<IMWE<T>> found;
    private final List<IMWE<T>> falseNegatives;
    private final List<IMWE<T>> falsePositives;
    private final List<IMWE<T>> truePositives;

    public SentenceResult(List<IMWE<T>> answer, List<IMWE<T>> retrieved, S sentence) {
        this(answer, retrieved, sentence, true);
    }

    public SentenceResult(List<IMWE<T>> answer, List<IMWE<T>> retrieved, S sentence, boolean reallocate) {
        this.sentence = sentence;
        this.answers = reallocate ? new ArrayList(answer) : answer;
        this.found = reallocate ? new ArrayList(retrieved) : retrieved;
        this.falseNegatives = new ArrayList<IMWE<T>>();
        this.falsePositives = new ArrayList<IMWE<T>>();
        this.truePositives = new ArrayList<IMWE<T>>();
        for (IMWE<T> item : this.found) {
            if (this.answers.contains(item)) {
                this.truePositives.add(item);
                continue;
            }
            this.falsePositives.add(item);
        }
        for (IMWE<T> ans : this.answers) {
            if (this.found.contains(ans)) continue;
            this.falseNegatives.add(ans);
        }
        this.precision = MWEResult.calcPrecision(this.truePositives.size(), this.found.size());
        this.recall = MWEResult.calcRecall(this.truePositives.size(), this.answers.size());
        this.fscore = MWEResult.calcF1Score(this.precision, this.recall);
    }

    @Override
    public S getSentence() {
        return this.sentence;
    }

    @Override
    public List<IMWE<T>> getFalseNegatives() {
        return Collections.unmodifiableList(this.falseNegatives);
    }

    @Override
    public List<IMWE<T>> getFalsePositives() {
        return Collections.unmodifiableList(this.falsePositives);
    }

    @Override
    public List<IMWE<T>> getTruePositives() {
        return Collections.unmodifiableList(this.truePositives);
    }

    @Override
    public List<IMWE<T>> getAnswers() {
        return Collections.unmodifiableList(this.answers);
    }

    @Override
    public List<IMWE<T>> getFound() {
        return Collections.unmodifiableList(this.found);
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public double getRecall() {
        return this.recall;
    }

    @Override
    public double getFScore() {
        return this.fscore;
    }

    @Override
    public int getTotalAnswers() {
        return this.answers.size();
    }

    @Override
    public int getTotalCorrect() {
        return this.truePositives.size();
    }

    @Override
    public int getTotalFound() {
        return this.found.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("correct: " + this.getTruePositives());
        sb.append("\nfalse positive: " + this.getFalsePositives());
        sb.append("\nfalse negative: " + this.getFalseNegatives());
        sb.append('\n');
        return sb.toString();
    }

    public static <T extends IToken, U extends IMarkedSentence<T>> String toString(ISentenceResult<T, U> result, U sentence) {
        return SentenceResult.toString(result, sentence, true);
    }

    public static <T extends IToken, S extends IMarkedSentence<T>> String toString(ISentenceResult<T, S> result, S sentence, boolean table) {
        StringBuilder sb = new StringBuilder(1024);
        Formatter f = new Formatter(sb);
        HashMap<IToken, ArrayList<Object>> map = new HashMap<IToken, ArrayList<Object>>(sentence.size());
        Object[] initial = new String[result.getTotalFound()];
        Arrays.fill(initial, "");
        for (IToken token : sentence) {
            map.put(token, new ArrayList<Object>(Arrays.asList(initial)));
        }
        for (int i = 0; i < result.getTotalFound(); ++i) {
            IMWE<T> mwe = result.getFound().get(i);
            for (IToken tkn : mwe.getTokens()) {
                ((List)map.get(tkn)).set(i, tkn.getForm().concat("_" + tkn.getTag()));
            }
        }
        sb.append("=================================================\n");
        sb.append(sentence.getID());
        sb.append('\n');
        for (IToken token : sentence) {
            String args = "%1$-" + (token.getForm().concat("_" + token.getTag()).length() + 1) + "s";
            f.format(args, token.getForm().concat("_" + token.getTag()));
        }
        sb.append('\n');
        for (int i = 0; i < result.getTotalFound(); ++i) {
            for (IToken token : sentence) {
                String args = "%1$-" + (token.getForm().concat("_" + token.getTag()).length() + 1) + "s";
                f.format(args, ((List)map.get(token)).get(i));
            }
            sb.append('\n');
        }
        sb.append('\n');
        if (table) {
            SentenceResult.printTable(sb, result, f);
        }
        return sb.toString();
    }

    public static <T extends IToken, S extends IMarkedSentence<T>> void printTable(StringBuilder sb, ISentenceResult<T, S> result, Formatter f) {
        String[] headers = new String[]{"Correct:", "False Negatives:", "False Positives:"};
        HashMap<String, List<IMWE<T>>> resultMap = new HashMap<String, List<IMWE<T>>>();
        resultMap.put("Correct:", result.getTruePositives());
        resultMap.put("False Negatives:", result.getFalseNegatives());
        resultMap.put("False Positives:", result.getFalsePositives());
        int max = Collections.max(Arrays.asList(result.getTruePositives().size(), result.getFalsePositives().size(), result.getFalseNegatives().size()));
        for (String header : headers) {
            for (int i = 0; i < 90; ++i) {
                f.format("%1$s", "-");
            }
        }
        f.format("%1$s", "\n");
        for (String header : headers) {
            f.format("%1$-90s", header);
        }
        sb.append('\n');
        for (int i = 0; i < max; ++i) {
            for (String header : headers) {
                if (i < ((List)resultMap.get(header)).size()) {
                    f.format("%1$-90s", ((List)resultMap.get(header)).get(i));
                    continue;
                }
                f.format("%1$-90s", "");
            }
            sb.append('\n');
        }
        sb.append('\n');
    }
}

