/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.IResultBuilder;
import edu.mit.jmwe.harness.result.ISentenceResult;
import edu.mit.jmwe.harness.result.MWEResult;
import edu.mit.jmwe.util.AtomicDouble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEResultBuilder<T extends IToken, S extends IMarkedSentence<T>>
implements IResultBuilder<T, S> {
    public final Map<MWEPOS, AtomicInteger> answerData = this.initIntegerMap();
    public final Map<MWEPOS, AtomicInteger> foundData = this.initIntegerMap();
    public final Map<MWEPOS, AtomicInteger> correctData = this.initIntegerMap();
    public final Map<MWEPOS, AtomicDouble<T, S>> partialScores = this.initDoubleMap();
    public final Map<String, ISentenceResult<T, S>> details;

    public MWEResultBuilder() {
        this(true);
    }

    public MWEResultBuilder(boolean captureDetails) {
        this.details = captureDetails ? new TreeMap() : null;
    }

    @Override
    public void process(List<IMWE<T>> found, List<IMWE<T>> answers) {
        MWEPOS pos;
        ArrayList<IMWE<T>> truePos = new ArrayList<IMWE<T>>();
        HashMap falsePos = new HashMap();
        for (MWEPOS ps : MWEPOS.values()) {
            falsePos.put(ps, new ArrayList());
        }
        for (IMWE<T> mwe : found) {
            pos = mwe.getEntry().getPOS();
            this.foundData.get((Object)pos).incrementAndGet();
            if (answers.contains(mwe)) {
                truePos.add(mwe);
                this.correctData.get((Object)pos).incrementAndGet();
                continue;
            }
            ((List)falsePos.get((Object)mwe.getEntry().getPOS())).add(mwe);
        }
        HashMap<IMWE<Object>, Double> falseNeg = new HashMap<IMWE<Object>, Double>();
        for (IMWE<T> mwe : answers) {
            pos = mwe.getEntry().getPOS();
            this.answerData.get((Object)pos).incrementAndGet();
            if (truePos.contains(mwe)) continue;
            falseNeg.put(mwe, 0.0);
        }
        for (Map.Entry e : falseNeg.entrySet()) {
            for (IMWE m : (List)falsePos.get((Object)((IMWE)e.getKey()).getEntry().getPOS())) {
                double overlap = MWE.overlap((IMWE)e.getKey(), m);
                if (!(overlap > (Double)e.getValue())) continue;
                falseNeg.put((IMWE<Object>)e.getKey(), overlap);
            }
        }
        for (Map.Entry e : falseNeg.entrySet()) {
            pos = ((IMWE)e.getKey()).getEntry().getPOS();
            this.partialScores.get((Object)pos).increment((Double)e.getValue());
        }
    }

    @Override
    public void addDetail(String ID, ISentenceResult<T, S> detail) {
        if (detail != null) {
            this.details.put(ID, detail);
        }
    }

    @Override
    public MWEResult<T, S> createResult() {
        Map<MWEPOS, Integer> answers = this.toIntMap(this.answerData);
        Map<MWEPOS, Integer> found = this.toIntMap(this.foundData);
        Map<MWEPOS, Integer> correct = this.toIntMap(this.correctData);
        Map<MWEPOS, Double> partial = this.toDblMap(this.partialScores);
        return new MWEResult<T, S>(answers, found, correct, partial, this.details);
    }

    protected Map<MWEPOS, Integer> toIntMap(Map<MWEPOS, AtomicInteger> map) {
        HashMap<MWEPOS, Integer> result = new HashMap<MWEPOS, Integer>(map.size());
        for (Map.Entry<MWEPOS, AtomicInteger> e : map.entrySet()) {
            result.put(e.getKey(), e.getValue().intValue());
        }
        return result;
    }

    protected Map<MWEPOS, Double> toDblMap(Map<MWEPOS, AtomicDouble<T, S>> map) {
        HashMap<MWEPOS, Double> result = new HashMap<MWEPOS, Double>(map.size());
        for (Map.Entry<MWEPOS, AtomicDouble<T, S>> e : map.entrySet()) {
            result.put(e.getKey(), e.getValue().doubleValue());
        }
        return result;
    }

    public String toString() {
        return ((MWEResult)this.createResult()).toString();
    }

    protected Map<MWEPOS, AtomicInteger> initIntegerMap() {
        HashMap<MWEPOS, AtomicInteger> map = new HashMap<MWEPOS, AtomicInteger>(MWEPOS.values().length);
        for (MWEPOS pos : MWEPOS.values()) {
            map.put(pos, new AtomicInteger());
        }
        return map;
    }

    protected Map<MWEPOS, AtomicDouble<T, S>> initDoubleMap() {
        HashMap<MWEPOS, AtomicDouble<T, S>> map = new HashMap<MWEPOS, AtomicDouble<T, S>>(MWEPOS.values().length);
        for (MWEPOS pos : MWEPOS.values()) {
            map.put(pos, new AtomicDouble());
        }
        return map;
    }
}

