/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result;

import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.harness.result.IOverallResult;
import edu.mit.jmwe.harness.result.ISentenceResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEResult<T extends IToken, S extends IMarkedSentence<T>>
implements IOverallResult<T, S> {
    private final Map<MWEPOS, Integer> answerData;
    private final Map<MWEPOS, Integer> foundData;
    private final Map<MWEPOS, Integer> correctData;
    private final Map<MWEPOS, Double> partialScores;
    private final Map<String, ISentenceResult<T, S>> details;
    private double precision = Double.NaN;
    private double recall = Double.NaN;
    private double f1score = Double.NaN;
    private double partialPrecision = Double.NaN;
    private double partialRecall = Double.NaN;
    private double partialF1Score = Double.NaN;
    private double partialScore = Double.NaN;
    private int totalRetrieved = -1;
    private int totalAnswers = -1;
    private int totalCorrect = -1;
    private Map<MWEPOS, Double> precisionScores;
    private Map<MWEPOS, Double> recallScores;
    private Map<MWEPOS, Double> f1Scores;
    private Map<MWEPOS, Double> partialPrecisionScores;
    private Map<MWEPOS, Double> partialRecallScores;
    private Map<MWEPOS, Double> partialF1Scores;

    public MWEResult(Map<MWEPOS, Integer> answer, Map<MWEPOS, Integer> found, Map<MWEPOS, Integer> correct, Map<MWEPOS, Double> partial, Map<String, ISentenceResult<T, S>> detailed) {
        this.answerData = Collections.unmodifiableMap(answer);
        this.foundData = Collections.unmodifiableMap(found);
        this.correctData = Collections.unmodifiableMap(correct);
        this.partialScores = Collections.unmodifiableMap(partial);
        this.details = detailed;
    }

    @Override
    public double getPrecision() {
        if (Double.isNaN(this.precision)) {
            this.precision = this.calcPrecision(null);
        }
        return this.precision;
    }

    @Override
    public double getRecall() {
        if (Double.isNaN(this.recall)) {
            this.recall = this.calcRecall(null);
        }
        return this.recall;
    }

    @Override
    public Map<MWEPOS, Double> getPrecisionScores() {
        if (this.precisionScores == null) {
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, this.calcPrecision(p));
            }
            this.precisionScores = Collections.unmodifiableMap(map);
        }
        return this.precisionScores;
    }

    @Override
    public Map<MWEPOS, Double> getRecallScores() {
        if (this.recallScores == null) {
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, this.calcRecall(p));
            }
            this.recallScores = Collections.unmodifiableMap(map);
        }
        return this.recallScores;
    }

    @Override
    public Map<MWEPOS, Double> getF1Scores() {
        if (this.f1Scores == null) {
            Map<MWEPOS, Double> ps = this.getPrecisionScores();
            Map<MWEPOS, Double> rs = this.getRecallScores();
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, MWEResult.calcF1Score(ps.get((Object)p), rs.get((Object)p)));
            }
            this.f1Scores = Collections.unmodifiableMap(map);
        }
        return this.f1Scores;
    }

    @Override
    public int getTotalAnswers() {
        if (this.totalAnswers == -1) {
            this.totalAnswers = MWEResult.sumInt(this.answerData.values());
        }
        return this.totalAnswers;
    }

    @Override
    public int getTotalCorrect() {
        if (this.totalCorrect == -1) {
            this.totalCorrect = MWEResult.sumInt(this.correctData.values());
        }
        return this.totalCorrect;
    }

    @Override
    public int getTotalFound() {
        if (this.totalRetrieved == -1) {
            this.totalRetrieved = MWEResult.sumInt(this.foundData.values());
        }
        return this.totalRetrieved;
    }

    @Override
    public Map<MWEPOS, Integer> getAnswerData() {
        return this.answerData;
    }

    @Override
    public Map<MWEPOS, Integer> getFoundData() {
        return this.foundData;
    }

    @Override
    public Map<MWEPOS, Integer> getCorrectData() {
        return this.correctData;
    }

    @Override
    public double getPartialPrecision() {
        if (Double.isNaN(this.partialPrecision)) {
            this.partialPrecision = this.calcPartialPrecision(null);
        }
        return this.partialPrecision;
    }

    @Override
    public double getPartialRecall() {
        if (Double.isNaN(this.partialRecall)) {
            this.partialRecall = this.calcPartialRecall(null);
        }
        return this.partialRecall;
    }

    @Override
    public Map<MWEPOS, Double> getPartialScores() {
        return this.partialScores;
    }

    @Override
    public Map<MWEPOS, Double> getPartialPrecisionScores() {
        if (this.partialPrecisionScores == null) {
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, this.calcPartialPrecision(p));
            }
            this.partialPrecisionScores = Collections.unmodifiableMap(map);
        }
        return this.partialPrecisionScores;
    }

    @Override
    public Map<MWEPOS, Double> getPartialRecallScores() {
        if (this.partialRecallScores == null) {
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, this.calcPartialRecall(p));
            }
            this.partialRecallScores = Collections.unmodifiableMap(map);
        }
        return this.partialRecallScores;
    }

    @Override
    public Map<MWEPOS, Double> getPartialF1Scores() {
        if (this.partialF1Scores == null) {
            Map<MWEPOS, Double> ps = this.getPartialPrecisionScores();
            Map<MWEPOS, Double> rs = this.getPartialRecallScores();
            HashMap<MWEPOS, Double> map = new HashMap<MWEPOS, Double>(MWEPOS.values().length);
            for (MWEPOS p : MWEPOS.values()) {
                map.put(p, MWEResult.calcF1Score(ps.get((Object)p), rs.get((Object)p)));
            }
            this.partialF1Scores = Collections.unmodifiableMap(map);
        }
        return this.partialF1Scores;
    }

    @Override
    public double getPartialScore() {
        if (Double.isNaN(this.partialScore)) {
            this.partialScore = MWEResult.sumDbl(this.partialScores.values());
        }
        return this.partialScore;
    }

    @Override
    public double getFScore() {
        if (Double.isNaN(this.f1score)) {
            this.f1score = MWEResult.calcF1Score(this.getPrecision(), this.getRecall());
        }
        return this.f1score;
    }

    @Override
    public double getPartialF1Score() {
        if (Double.isNaN(this.partialF1Score)) {
            this.partialF1Score = MWEResult.calcF1Score(this.getPartialPrecision(), this.getPartialRecall());
        }
        return this.partialF1Score;
    }

    @Override
    public Map<String, ISentenceResult<T, S>> getDetails() {
        return this.details;
    }

    public String toString() {
        return MWEResult.toString(this);
    }

    protected double calcPrecision(MWEPOS pos) {
        EnumSet<MWEPOS> ps = pos == null ? EnumSet.allOf(MWEPOS.class) : EnumSet.of(pos);
        int correctlyRetrieved = 0;
        int totalRetrieved = 0;
        for (MWEPOS p : ps) {
            totalRetrieved += this.foundData.get((Object)p).intValue();
            correctlyRetrieved += this.correctData.get((Object)p).intValue();
        }
        return MWEResult.calcPrecision(correctlyRetrieved, totalRetrieved);
    }

    protected double calcRecall(MWEPOS pos) {
        EnumSet<MWEPOS> ps = pos == null ? EnumSet.allOf(MWEPOS.class) : EnumSet.of(pos);
        int correctlyRetrieved = 0;
        int totalActual = 0;
        for (MWEPOS p : ps) {
            totalActual += this.answerData.get((Object)p).intValue();
            correctlyRetrieved += this.correctData.get((Object)p).intValue();
        }
        return MWEResult.calcRecall(correctlyRetrieved, totalActual);
    }

    protected double calcPartialPrecision(MWEPOS pos) {
        EnumSet<MWEPOS> ps = pos == null ? EnumSet.allOf(MWEPOS.class) : EnumSet.of(pos);
        double correctlyRetrieved = 0.0;
        int totalRetrieved = 0;
        for (MWEPOS p : ps) {
            correctlyRetrieved += (double)this.correctData.get((Object)p).intValue();
            correctlyRetrieved += this.partialScores.get((Object)p).doubleValue();
            totalRetrieved += this.foundData.get((Object)p).intValue();
        }
        return MWEResult.calcPrecision(correctlyRetrieved, totalRetrieved);
    }

    protected double calcPartialRecall(MWEPOS pos) {
        EnumSet<MWEPOS> ps = pos == null ? EnumSet.allOf(MWEPOS.class) : EnumSet.of(pos);
        double correctlyRetrieved = 0.0;
        int totalActual = 0;
        for (MWEPOS p : ps) {
            correctlyRetrieved += (double)this.correctData.get((Object)p).intValue();
            correctlyRetrieved += this.partialScores.get((Object)p).doubleValue();
            totalActual += this.answerData.get((Object)p).intValue();
        }
        return MWEResult.calcRecall(correctlyRetrieved, totalActual);
    }

    public static String toString(IOverallResult<?, ?> result) {
        int i;
        String strFmt = "%1$-12s";
        String intFmt = "%1$-8s";
        String dblFmt = "%1$-10.3f";
        String dblFmtH = "%1$-10s";
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> formatsH = new ArrayList<String>();
        ArrayList<String> formats = new ArrayList<String>();
        ArrayList<Map<MWEPOS, Number>> maps = new ArrayList<Map<MWEPOS, Number>>();
        ArrayList<Object> totals = new ArrayList<Object>();
        headers.add("POS");
        formats.add(strFmt);
        formatsH.add(strFmt);
        maps.add(null);
        totals.add("Totals");
        headers.add("Found");
        formats.add(intFmt);
        formatsH.add(intFmt);
        maps.add(result.getFoundData());
        totals.add(result.getTotalFound());
        headers.add("Actual");
        formats.add(intFmt);
        formatsH.add(intFmt);
        maps.add(result.getAnswerData());
        totals.add(result.getTotalAnswers());
        headers.add("Correct");
        formats.add(intFmt);
        formatsH.add(intFmt);
        maps.add(result.getCorrectData());
        totals.add(result.getTotalCorrect());
        headers.add("F1");
        formats.add(dblFmt);
        formatsH.add(dblFmtH);
        maps.add(result.getF1Scores());
        totals.add(result.getFScore());
        headers.add("Pr");
        formats.add(dblFmt);
        formatsH.add(dblFmtH);
        maps.add(result.getPrecisionScores());
        totals.add(result.getPrecision());
        headers.add("Re");
        formats.add(dblFmt);
        formatsH.add(dblFmtH);
        maps.add(result.getRecallScores());
        totals.add(result.getRecall());
        StringBuilder sb = new StringBuilder(1024);
        Formatter f = new Formatter(sb);
        for (int i2 = 0; i2 < headers.size(); ++i2) {
            f.format((String)formatsH.get(i2), headers.get(i2));
        }
        int length = sb.length();
        sb.append('\n');
        for (int i3 = 0; i3 < length; ++i3) {
            sb.append('-');
        }
        sb.append('\n');
        for (MWEPOS pos : MWEPOS.values()) {
            for (int i4 = 0; i4 < headers.size(); ++i4) {
                Map map = (Map)maps.get(i4);
                if (map == null) {
                    f.format((String)formats.get(i4), pos.name());
                    continue;
                }
                f.format((String)formats.get(i4), ((Map)maps.get(i4)).get((Object)pos));
            }
            sb.append('\n');
        }
        for (i = 0; i < length; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        for (i = 0; i < totals.size(); ++i) {
            f.format((String)formats.get(i), totals.get(i));
        }
        sb.append("\n");
        f.close();
        return sb.toString();
    }

    public static double calcPrecision(double correctlyRetrieved, double totalRetrieved) {
        if (totalRetrieved == 0.0 && correctlyRetrieved == 0.0) {
            return 1.0;
        }
        if (totalRetrieved == 0.0) {
            return Double.NaN;
        }
        double result = correctlyRetrieved / totalRetrieved;
        if (result > 1.0 || result < 0.0) {
            throw new IllegalStateException();
        }
        return result;
    }

    public static double calcRecall(double correctlyRetrieved, double totalAnswers) {
        if (totalAnswers == 0.0 && correctlyRetrieved == 0.0) {
            return 1.0;
        }
        if (totalAnswers == 0.0) {
            return Double.NaN;
        }
        double result = correctlyRetrieved / totalAnswers;
        if (result > 1.0 || result < 0.0) {
            throw new IllegalStateException();
        }
        return result;
    }

    public static double calcF1Score(double precision, double recall) {
        if (precision > 1.0 || precision < 0.0 || recall > 1.0 || recall < 0.0) {
            throw new IllegalStateException();
        }
        if (precision == Double.NaN || recall == Double.NaN) {
            return Double.NaN;
        }
        return 2.0 * (precision * recall) / (precision + recall);
    }

    public static int sumInt(Iterable<? extends Integer> m) {
        int result = 0;
        for (Integer n : m) {
            result += n.intValue();
        }
        return result;
    }

    public static double sumDbl(Iterable<? extends Double> m) {
        double result = 0.0;
        for (Double d : m) {
            result += d.doubleValue();
        }
        return result;
    }
}

