/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness.result;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.harness.result.IErrorResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorResult<T extends IToken>
implements IErrorResult<T> {
    private final Map<String, List<IMWE<T>>> details;
    private final int totalErrors;

    public ErrorResult(String errorID, List<IMWE<T>> errors) {
        this(Collections.singletonMap(errorID, errors));
    }

    public ErrorResult(Map<String, List<IMWE<T>>> details) {
        this(details, true);
    }

    public ErrorResult(Map<String, List<IMWE<T>>> details, boolean reallocate) {
        this.details = reallocate ? Collections.unmodifiableMap(details) : details;
        int sum = 0;
        for (List<IMWE<T>> mwes : details.values()) {
            sum += mwes.size();
        }
        this.totalErrors = sum;
    }

    @Override
    public Map<String, List<IMWE<T>>> getDetails() {
        return this.details;
    }

    @Override
    public int getTotalErrors() {
        return this.totalErrors;
    }

    @Override
    public int getNumErrors(String errorID) {
        List<IMWE<T>> list = this.details.get(errorID);
        return list == null ? 0 : list.size();
    }

    public String toString() {
        return ErrorResult.toString(this);
    }

    public static <T extends IToken> String toString(IErrorResult<T> result) {
        String strFmt = "%1$-60s";
        StringBuilder sb = new StringBuilder(1024);
        Formatter f = new Formatter(sb);
        f.format(strFmt, "Error");
        f.format(strFmt, "Instances");
        int length = sb.length();
        sb.append('\n');
        for (int i = 0; i < length; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        for (String error : result.getDetails().keySet()) {
            f.format(strFmt, error);
            f.format(strFmt, result.getNumErrors(error));
            sb.append('\n');
        }
        for (int i = 0; i < length; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        f.format(strFmt, "Total");
        f.format(strFmt, result.getTotalErrors());
        sb.append('\n');
        f.close();
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorResultBuilder<T extends IToken> {
        private final Map<String, List<IMWE<T>>> details = new HashMap<String, List<IMWE<T>>>();

        public void addDetail(IErrorResult<T> result) {
            for (Map.Entry<String, List<IMWE<T>>> e : result.getDetails().entrySet()) {
                List<IMWE<T>> list = this.details.get(e.getKey());
                if (list == null) {
                    list = new LinkedList<IMWE<T>>();
                    this.details.put(e.getKey(), list);
                }
                list.addAll((Collection)e.getValue());
            }
        }

        public IErrorResult<T> create() {
            return new ErrorResult<T>(this.details);
        }
    }
}

