/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.harness.IAnswerKey;
import edu.mit.jmwe.harness.ITestHarness;
import edu.mit.jmwe.harness.result.IResultBuilder;
import edu.mit.jmwe.harness.result.SentenceResult;
import edu.mit.jmwe.util.IProgressBar;
import edu.mit.jmwe.util.NullProgressBar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHarness
implements ITestHarness {
    private static TestHarness instance = null;

    public static TestHarness getInstance() {
        if (instance == null) {
            instance = new TestHarness();
        }
        return instance;
    }

    protected TestHarness() {
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> void run(IMWEDetector detector, IResultBuilder<T, S> result, Iterator<S> itr, IAnswerKey answers, IProgressBar pb) {
        this.run(Collections.singletonMap(detector, result), itr, answers, pb);
    }

    @Override
    public <T extends IToken, S extends IMarkedSentence<T>> void run(Map<IMWEDetector, IResultBuilder<T, S>> detectors, Iterator<S> itr, IAnswerKey answers, IProgressBar pb) {
        for (Map.Entry<IMWEDetector, IResultBuilder<T, S>> e : detectors.entrySet()) {
            if (e.getKey() == null) {
                throw new NullPointerException();
            }
            if (e.getValue() != null) continue;
            throw new NullPointerException();
        }
        if (pb == null) {
            pb = NullProgressBar.getInstance();
        }
        while (itr.hasNext()) {
            IMarkedSentence sent = (IMarkedSentence)itr.next();
            List answerMWEs = answers.getAnswers(sent);
            this.runDetectors(detectors, sent, answerMWEs);
            pb.increment();
        }
        pb.finish();
    }

    protected <T extends IToken, S extends IMarkedSentence<T>> void runDetectors(Map<IMWEDetector, IResultBuilder<T, S>> detectors, S sent, List<IMWE<T>> answers) {
        for (Map.Entry<IMWEDetector, IResultBuilder<T, S>> e : detectors.entrySet()) {
            this.runDetector(e.getKey(), e.getValue(), sent, answers);
        }
    }

    protected <T extends IToken, S extends IMarkedSentence<T>> List<IMWE<T>> runDetector(IMWEDetector detector, IResultBuilder<T, S> builder, S sent, List<IMWE<T>> answers) {
        List results = detector.detect(sent);
        builder.process(results, answers);
        builder.addDetail(sent.getID(), new SentenceResult<T, S>(answers, results, sent));
        return results;
    }
}

