/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.harness;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.data.RootMWEDesc;
import edu.mit.jmwe.harness.IAnswerKey;
import edu.mit.jsemcor.element.IContext;
import edu.mit.jsemcor.element.ISemanticTag;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.element.IWordform;
import edu.mit.jsemcor.main.IConcordance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordanceAnswerKey
implements IAnswerKey {
    public static final Pattern condordanceSentenceIDPattern = Pattern.compile("(\\S+?)/(\\S+?)/(\\d+)");
    public static final Pattern lexSensePattern = Pattern.compile("(\\d):(\\d\\d):(\\d\\d):?:((\\S+):(\\d\\d))?");
    private final Map<String, IConcordance> concords;
    private boolean ignoreProperNouns = false;

    public ConcordanceAnswerKey(IConcordance c) {
        this(Arrays.asList(c));
    }

    public ConcordanceAnswerKey(Iterable<? extends IConcordance> i) {
        HashMap<String, IConcordance> concords = new HashMap<String, IConcordance>();
        for (IConcordance iConcordance : i) {
            concords.put(iConcordance.getName(), iConcordance);
        }
        this.concords = concords;
    }

    public ConcordanceAnswerKey(Map<String, IConcordance> concords) {
        if (concords == null) {
            throw new NullPointerException();
        }
        this.concords = concords;
    }

    public boolean isIgnoringProperNouns() {
        return this.ignoreProperNouns;
    }

    public void setIgnoreProperNouns(boolean ignoreProperNouns) {
        this.ignoreProperNouns = ignoreProperNouns;
    }

    @Override
    public <T extends IToken> List<IMWE<T>> getAnswers(IMarkedSentence<T> sent) {
        ISentence answers = ConcordanceAnswerKey.getSentence(this.concords, sent);
        return this.getAnswers(sent, answers);
    }

    public <T extends IToken> List<IMWE<T>> getAnswers(IMarkedSentence<T> sent, ISentence answers) {
        if (sent == null) {
            throw new NullPointerException();
        }
        if (answers == null) {
            throw new NullPointerException();
        }
        HashSet<IWordform> used = new HashSet<IWordform>(answers.getWordList().size());
        List<IMWE<T>> mwes = this.getNonContinuousMWEs(sent, answers, used);
        List<IMWE<T>> adjMwes = this.getContinuousMWEs(sent, answers, used);
        ArrayList<IMWE<T>> result = new ArrayList<IMWE<T>>(adjMwes.size() + mwes.size());
        result.addAll(adjMwes);
        result.addAll(mwes);
        Collections.sort(result, new MWEComparator<T>(sent));
        return result;
    }

    protected <T extends IToken> List<IMWE<T>> getNonContinuousMWEs(IMarkedSentence<T> sent, ISentence answer, Set<IWordform> used) {
        if (sent == null) {
            throw new NullPointerException();
        }
        List nonContMWEs = answer.getCollocations();
        int unitIdx = 0;
        HashMap<IWordform, Integer> idxMap = new HashMap<IWordform, Integer>(answer.size());
        for (edu.mit.jsemcor.element.IToken answerToken : answer) {
            if (answerToken instanceof IWordform) {
                IWordform wf = (IWordform)answerToken;
                idxMap.put(wf, unitIdx);
                unitIdx += wf.getConstituentTokens().size();
                continue;
            }
            ++unitIdx;
        }
        ArrayList<IMWE<T>> results = new ArrayList<IMWE<T>>(nonContMWEs.size());
        MWEPOS pos = null;
        ArrayList<IToken> parts = new ArrayList<IToken>();
        LinkedHashMap partMap = new LinkedHashMap();
        ISemanticTag semTag = null;
        for (List cs : nonContMWEs) {
            String lemma;
            semTag = null;
            parts.clear();
            partMap.clear();
            for (IWordform wf : cs) {
                if (wf.getConstituentTokens().size() > 1) {
                    used.add(wf);
                }
                if (wf.getSemanticTag() != null) {
                    if (semTag != null) {
                        throw new IllegalStateException();
                    }
                    semTag = wf.getSemanticTag();
                }
                IToken token = (IToken)sent.get((Integer)idxMap.get(wf));
                parts.add(token);
                partMap.put(token, null);
            }
            if (ConcordanceAnswerKey.isIllformattedLemma(semTag)) {
                StringBuilder sb = new StringBuilder();
                Iterator i = cs.iterator();
                while (i.hasNext()) {
                    sb.append(((IWordform)i.next()).getText().toLowerCase());
                    if (!i.hasNext()) continue;
                    sb.append('_');
                }
                lemma = sb.toString();
            } else {
                lemma = semTag.getLemma();
            }
            if (semTag == null) {
                for (IWordform wf : cs) {
                    if (wf.getPOSTag() == null) continue;
                    if (pos != null && !pos.equals((Object)MWEPOS.toMWEPOS(wf.getPOSTag().getValue()))) {
                        pos = this.disambiguatePOS(cs);
                        if (pos != null) continue;
                        throw new IllegalStateException();
                    }
                    pos = MWEPOS.toMWEPOS(wf.getPOSTag().getValue());
                }
            } else {
                pos = this.getMWEPOS((String)semTag.getLexicalSense().get(0));
            }
            RootMWEDesc mweDesc = new RootMWEDesc(lemma, pos);
            int i = 0;
            for (Map.Entry entry : partMap.entrySet()) {
                entry.setValue(mweDesc.getParts().get(i++));
            }
            if (this.ignoreProperNouns && pos == MWEPOS.PROPER_NOUN) continue;
            results.add(new MWE(partMap));
        }
        return results;
    }

    protected <T extends IToken> List<IMWE<T>> getContinuousMWEs(IMarkedSentence<T> sent, ISentence answer, Set<IWordform> used) {
        if (sent == null) {
            throw new NullPointerException();
        }
        LinkedList<IMWE<T>> results = new LinkedList<IMWE<T>>();
        int tokenIdx = 0;
        for (edu.mit.jsemcor.element.IToken wordform : answer) {
            if (!(wordform instanceof IWordform)) {
                ++tokenIdx;
                continue;
            }
            IWordform wf = (IWordform)wordform;
            if (wf.getConstituentTokens().size() <= 1) {
                ++tokenIdx;
                continue;
            }
            if (used.contains(wf)) {
                ++tokenIdx;
                continue;
            }
            StringBuilder backupLemma = new StringBuilder();
            LinkedHashMap partMap = new LinkedHashMap();
            Iterator i = wf.getConstituentTokens().iterator();
            while (i.hasNext()) {
                IToken token = (IToken)sent.get(tokenIdx);
                partMap.put(token, null);
                backupLemma.append(((String)i.next()).toLowerCase());
                if (i.hasNext()) {
                    backupLemma.append("_");
                }
                ++tokenIdx;
            }
            MWEPOS mwePOS = MWEPOS.toMWEPOS(wf.getPOSTag().getValue());
            if (this.ignoreProperNouns && mwePOS == MWEPOS.PROPER_NOUN) continue;
            int numParts = wf.getConstituentTokens().size();
            String[] lemmaParts = wf.getSemanticTag() != null ? AbstractMWEDesc.underscore.split(wf.getSemanticTag().getLemma()) : new String[]{};
            String mweLemma = ConcordanceAnswerKey.isIllformattedLemma(wf.getSemanticTag()) || numParts != lemmaParts.length ? backupLemma.toString() : wf.getSemanticTag().getLemma();
            RootMWEDesc mweDesc = new RootMWEDesc(mweLemma, mwePOS);
            int i2 = 0;
            for (Map.Entry entry : partMap.entrySet()) {
                entry.setValue(mweDesc.getParts().get(i2++));
            }
            results.add(new MWE(partMap));
        }
        return results;
    }

    protected MWEPOS getMWEPOS(String lexSense) {
        Matcher matcher = lexSensePattern.matcher(lexSense);
        if (!matcher.matches()) {
            return null;
        }
        int num = Integer.parseInt(matcher.group(1));
        switch (num) {
            case 1: {
                return MWEPOS.NOUN;
            }
            case 2: {
                return MWEPOS.VERB;
            }
            case 4: {
                return MWEPOS.ADVERB;
            }
            case 3: 
            case 5: {
                return MWEPOS.ADJECTIVE;
            }
        }
        return null;
    }

    protected MWEPOS disambiguatePOS(List<IWordform> mwe) {
        if (mwe.size() != 2) {
            return null;
        }
        if (MWEPOS.toMWEPOS(mwe.get(0).getPOSTag().getValue()) == MWEPOS.VERB && mwe.get(1).getPOSTag().getValue().equals("IN")) {
            return MWEPOS.VERB;
        }
        return null;
    }

    public static ISentence getSentence(Map<String, IConcordance> concords, IMarkedSentence<?> sent) {
        Matcher matcher = condordanceSentenceIDPattern.matcher(sent.getID());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to find parse sentence id " + sent.getID());
        }
        String concordName = matcher.group(1);
        String contextName = matcher.group(2);
        int sentNum = Integer.parseInt(matcher.group(3));
        IConcordance concord = concords.get(concordName);
        if (concord == null) {
            throw new IllegalArgumentException("Unable to find answer condcordance for " + sent.getID());
        }
        IContext context = concord.getContext(contextName);
        if (context == null) {
            throw new IllegalArgumentException("Unable to find answer context for " + sent.getID());
        }
        ISentence answers = context.getSentence(sentNum);
        if (answers == null) {
            throw new IllegalArgumentException("Unable to find answer sentence for " + sent.getID());
        }
        return answers;
    }

    protected static boolean isIllformattedLemma(ISemanticTag tag) {
        if (tag == null) {
            return true;
        }
        if (tag.getProperNounCategory() != null) {
            return true;
        }
        return AbstractMWEDesc.splitOnUnderscores(tag.getLemma()).size() < 2;
    }
}

