/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect.score;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.score.AbstractScorer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarianceScore<T extends IToken>
extends AbstractScorer<IMWE<T>> {
    protected final Map<T, Integer> idxMap;

    public VarianceScore(List<T> sentence) {
        this.idxMap = Collections.unmodifiableMap(MWEComparator.createIndexMap(sentence));
    }

    @Override
    public double score(IMWE<T> mwe) {
        int sum = 0;
        double mean = 0.0;
        double variance = 0.0;
        for (IToken token : mwe.getTokens()) {
            sum += this.idxMap.get(token).intValue();
        }
        mean = sum / mwe.getTokens().size();
        for (IToken token : mwe.getTokens()) {
            variance += Math.pow((double)this.idxMap.get(token).intValue() - mean, 2.0);
        }
        return variance / (double)mwe.getTokens().size();
    }
}

