/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect.score;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.score.AbstractScorer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartingIndexScore<T extends IToken>
extends AbstractScorer<IMWE<T>> {
    protected final Map<T, Integer> idxMap;

    public StartingIndexScore(List<T> sentence) {
        this.idxMap = Collections.unmodifiableMap(MWEComparator.createIndexMap(sentence));
    }

    @Override
    public double score(IMWE<T> mwe) {
        IToken first = (IToken)mwe.getPartMap().keySet().iterator().next();
        return this.idxMap.get(first).intValue();
    }
}

