/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect.score;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.score.AbstractScorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionAsMWEScore<T extends IToken>
extends AbstractScorer<IMWE<T>> {
    private static FractionAsMWEScore<?> instance = null;

    public static <T extends IToken> FractionAsMWEScore<T> getInstance() {
        if (instance == null) {
            instance = new FractionAsMWEScore<T>();
        }
        return instance;
    }

    protected FractionAsMWEScore() {
    }

    @Override
    public double score(IMWE<T> mwe) {
        IMWEDesc desc = mwe.getEntry();
        double numer = desc.getMarkedContinuous();
        double denom = numer + (double)desc.getUnmarkedExact();
        if (Double.compare(denom, 0.0) == 0) {
            return 1.0;
        }
        return numer / denom;
    }
}

