/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.MWEBuilder;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.index.MWEIndex;
import edu.mit.jmwe.util.ListComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopWords
implements IMWEDetector {
    public static List<String> defaultIndex = Collections.unmodifiableList(Arrays.asList("and_then_R", "by_and_by_R", "as_to_J", "as_to_O", "as_is_V", "such_as_J", "as_it_is_R", "as_such_R", "at_will_R", "be_on_V", "be_with_it_V", "but_then_R", "in_for_J", "if_not_R", "in_on_R", "in_that_R", "in_this_R", "that_is_R", "be_with_it_V", "on_it_R", "to_it_R", "be_on_V", "in_on_R", "on_that_R", "such_that_J", "to_that_R", "with_that_R", "and_then_R", "but_then_R", "at_will_R", "with_that_R", "of_this_R", "of_it_R", "with_it_R", "of_that_R", "at_a_R", "this_and_that_R", "such_and_such_J", "in_the_R", "on_the_R", "such_as_R", "is_there_V", "was_there_V", "as_it_R", "of_a_N", "to_the_R"));
    private final IMWEIndex index;

    public StopWords() {
        this(StopWords.getStopWordIndex());
    }

    public StopWords(IMWEIndex index) {
        if (index == null) {
            throw new NullPointerException();
        }
        this.index = index;
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        HashMap recordMap = new HashMap();
        ListComparator<T> comparator = new ListComparator<T>(sentence);
        ArrayList<IRootMWEDesc> entries = new ArrayList<IRootMWEDesc>();
        for (IToken token : sentence) {
            entries.clear();
            if (token.getStems() != null) {
                for (String stem : token.getStems()) {
                    if (stem.equals(token.getForm().toLowerCase())) continue;
                    entries.addAll(this.index.get(stem));
                }
            }
            entries.addAll(this.index.get(token.getForm().toLowerCase()));
            for (IRootMWEDesc entry : entries) {
                HashSet records = (HashSet)recordMap.get(entry);
                if (records == null) {
                    records = new HashSet();
                    recordMap.put(entry, records);
                }
                records.add(new MWEBuilder<T>((IMWEDesc)entry, comparator));
                MWEBuilder.fillSlots(records, token);
            }
        }
        LinkedList<IMWE<T>> result = new LinkedList<IMWE<T>>();
        for (Set recList : recordMap.values()) {
            for (MWEBuilder rec : recList) {
                if (!rec.isFull() || result.contains(rec.toMWE())) continue;
                result.add(rec.toMWE());
            }
        }
        Collections.sort(result, new MWEComparator(comparator.getIndexMap()));
        return result;
    }

    protected static IMWEIndex getStopWordIndex() {
        MWEIndex index = new MWEIndex(defaultIndex);
        try {
            index.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return index;
    }
}

