/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorResolver;
import edu.mit.jmwe.detect.score.IScorer;
import edu.mit.jmwe.util.CompositeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolveByScore
extends HasMWEDetector
implements IMWEDetectorResolver {
    protected final boolean chooseLargest;

    public ResolveByScore(IMWEDetector detector, boolean chooseLargest) {
        super(detector);
        this.chooseLargest = chooseLargest;
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> results = super.detect(sentence);
        Comparator<IMWE<T>> scoreComp = this.getScorer(sentence);
        if (this.chooseLargest) {
            scoreComp = Collections.reverseOrder(scoreComp);
        }
        MWEComparator<T> mweComp = new MWEComparator<T>(sentence);
        CompositeComparator<IMWE<T>> c = new CompositeComparator<IMWE<T>>(scoreComp, mweComp);
        Collections.sort(results, c);
        LinkedList<IMWE<T>> queue = new LinkedList<IMWE<T>>(results);
        LinkedHashSet<IMWE<T>> resultSet = new LinkedHashSet<IMWE<T>>();
        while (!queue.isEmpty()) {
            IMWE<T> mwe = queue.removeFirst();
            if (!resultSet.add(mwe)) continue;
            Iterator i = queue.iterator();
            while (i.hasNext()) {
                if (!(MWE.overlap(mwe, (IMWE)i.next()) > 0.0)) continue;
                i.remove();
            }
        }
        results = new ArrayList<IMWE<T>>(resultSet);
        Collections.sort(results, mweComp);
        return results;
    }

    protected abstract <T extends IToken> IScorer<IMWE<T>> getScorer(List<T> var1);
}

