/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.data.RootMWEDesc;
import edu.mit.jmwe.detect.IMWEDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProperNouns
implements IMWEDetector {
    private static ProperNouns instance = null;

    public static ProperNouns getInstance() {
        if (instance == null) {
            instance = new ProperNouns();
        }
        return instance;
    }

    protected ProperNouns() {
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        LinkedList<IMWE<T>> result = new LinkedList<IMWE<T>>();
        LinkedList<IToken> tokens = null;
        boolean foundEnd = false;
        for (IToken token : sentence) {
            if (sentence.indexOf(token) == sentence.size() - 1) {
                foundEnd = true;
            }
            if (ProperNouns.isProperNoun(token)) {
                if (tokens == null) {
                    tokens = new LinkedList<IToken>();
                }
                tokens.add(token);
            } else {
                if (tokens == null) continue;
                if (this.isValidInterstitial(token, tokens)) {
                    tokens.add(token);
                    foundEnd = false;
                } else {
                    this.removeIncorrectInterstitials(tokens);
                    foundEnd = true;
                    if (tokens.isEmpty() || tokens.size() == 1) {
                        tokens = null;
                        foundEnd = false;
                        continue;
                    }
                }
            }
            if (!foundEnd || tokens.size() <= 1) continue;
            ArrayList<String> parts = new ArrayList<String>(tokens.size());
            for (IToken t : tokens) {
                parts.add(t.getForm());
            }
            RootMWEDesc mweDesc = new RootMWEDesc(parts, MWEPOS.PROPER_NOUN);
            LinkedHashMap idxparts = new LinkedHashMap();
            for (int i = 0; i < tokens.size(); ++i) {
                idxparts.put(tokens.get(i), mweDesc.getParts().get(i));
            }
            result.add(new MWE(idxparts));
            tokens = null;
            foundEnd = false;
        }
        Collections.sort(result, new MWEComparator<T>(sentence));
        return result;
    }

    protected <T extends IToken> boolean isValidInterstitial(T token, LinkedList<T> tokens) {
        return false;
    }

    protected <T extends IToken> void removeIncorrectInterstitials(LinkedList<T> cs) {
        if (cs.isEmpty()) {
            return;
        }
        while (!ProperNouns.isProperNoun((IToken)cs.getLast())) {
            cs.removeLast();
            if (!cs.isEmpty()) continue;
            return;
        }
    }

    public static <T extends IToken> boolean isProperNoun(T token) {
        String text = token.getForm();
        if (text.equals("(") || text.equals(")") || text.equals("\"")) {
            return false;
        }
        return MWEPOS.toMWEPOS(token.getTag()).equals((Object)MWEPOS.PROPER_NOUN);
    }
}

