/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMarkedSentence;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.harness.IAnswerKey;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Perfect
implements IMWEDetector {
    private final IAnswerKey key;

    public Perfect(IAnswerKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        if (sentence instanceof IMarkedSentence) {
            IMarkedSentence marked = (IMarkedSentence)sentence;
            return this.key.getAnswers(marked);
        }
        throw new IllegalArgumentException("Unable to locate answers for sentence: " + sentence);
    }
}

