/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.AbstractMWEDesc;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWE;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.data.RootMWEDesc;
import edu.mit.jmwe.util.ListComparator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEBuilder<T extends IToken> {
    private final IMWEDesc entry;
    private final Comparator<T> comparator;
    private final SortedMap<IMWEDesc.IPart, T> slots;
    private final boolean hasMultiple;

    public MWEBuilder(IMWEDesc entry, List<T> sentence) {
        this(entry, new ListComparator<T>(sentence));
    }

    public MWEBuilder(IMWEDesc entry, Comparator<T> comparator) {
        if (entry == null) {
            throw new NullPointerException();
        }
        if (comparator == null) {
            throw new NullPointerException();
        }
        TreeMap<IMWEDesc.IPart, T> slots = new TreeMap<IMWEDesc.IPart, T>();
        HashSet<String> uniqueParts = new HashSet<String>();
        for (IMWEDesc.IPart iPart : entry.getParts()) {
            slots.put(iPart, null);
            uniqueParts.add(iPart.getForm().toLowerCase());
        }
        this.hasMultiple = uniqueParts.size() < entry.getParts().size();
        this.entry = entry;
        this.comparator = comparator;
        this.slots = slots;
    }

    public IMWEDesc getEntry() {
        return this.entry;
    }

    public SortedMap<IMWEDesc.IPart, T> getSlots() {
        return this.slots;
    }

    public boolean isFull() {
        for (IToken token : this.slots.values()) {
            if (token != null) continue;
            return false;
        }
        return true;
    }

    public boolean isContentFull() {
        for (Map.Entry<IMWEDesc.IPart, T> slot : this.slots.entrySet()) {
            if (slot.getKey().isStopWord() || slot.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isPartOfSpeechSatisfied() {
        MWEPOS pos = this.entry.getPOS();
        for (IToken token : this.slots.values()) {
            if (token == null || token.getTag() == null || pos != MWEPOS.toMWEPOS(token.getTag())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmptyMatchingSlots(Map.Entry<IMWEDesc.IPart, T> slot) {
        if (!this.hasMultiple) {
            return true;
        }
        boolean first = true;
        for (Map.Entry<IMWEDesc.IPart, T> later : this.slots.tailMap(slot.getKey()).entrySet()) {
            if (first) {
                first = false;
                continue;
            }
            if (!later.getKey().getForm().equals(slot.getKey().getForm()) || later.getValue() == null) continue;
            return false;
        }
        return true;
    }

    public boolean hasMultiple() {
        return this.hasMultiple;
    }

    public MWEBuilder<T> clone() {
        MWEBuilder<T> clone = new MWEBuilder<T>(this.entry, this.comparator);
        clone.getSlots().putAll(this.slots);
        return clone;
    }

    public IMWE<T> toMWE() {
        if (!this.isFull()) {
            throw new IllegalStateException();
        }
        TreeMap<T, IMWEDesc.IPart> partMap = new TreeMap<T, IMWEDesc.IPart>(this.comparator);
        for (Map.Entry<IMWEDesc.IPart, T> e : this.slots.entrySet()) {
            if (partMap.put(e.getValue(), e.getKey()) == null) continue;
            throw new IllegalArgumentException("Duplicate token");
        }
        return new MWE<T>(partMap, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.entry.toString());
        sb.append('=');
        sb.append(this.slots.toString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entry.hashCode();
        result = 31 * result + this.slots.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MWEBuilder other = (MWEBuilder)obj;
        if (!this.entry.equals(other.entry)) {
            return false;
        }
        return this.slots.equals(other.slots);
    }

    public static <T extends IToken> void fillSlots(Set<MWEBuilder<T>> records, T token) {
        MWEBuilder<T> record;
        LinkedList<MWEBuilder<T>> queue = new LinkedList<MWEBuilder<T>>(records);
        records.clear();
        while ((record = queue.poll()) != null) {
            IMWEDesc.IPart filledSlot = null;
            for (Map.Entry<IMWEDesc.IPart, T> slot : record.getSlots().entrySet()) {
                Object copy;
                if (!RootMWEDesc.isFillerForSlot(token, slot.getKey()) || record.getSlots().containsValue(token)) continue;
                if (slot.getValue() != null && filledSlot == null) {
                    copy = record.clone();
                    if (record.hasEmptyMatchingSlots(slot)) {
                        ((MWEBuilder)copy).getSlots().put(slot.getKey(), token);
                    }
                    records.add((MWEBuilder<T>)copy);
                    continue;
                }
                if (filledSlot == null) {
                    slot.setValue(token);
                    filledSlot = slot.getKey();
                    records.add(record);
                    continue;
                }
                copy = record.clone();
                ((MWEBuilder)copy).getSlots().put(filledSlot, null);
                ((MWEBuilder)copy).getSlots().put(slot.getKey(), token);
                records.add((MWEBuilder<T>)copy);
            }
            records.add(record);
        }
    }

    public static <T extends IToken> boolean fillNextSlot(MWEBuilder<T> builder, T t) {
        Map.Entry<IMWEDesc.IPart, T> next = null;
        for (Map.Entry<IMWEDesc.IPart, T> e : builder.getSlots().entrySet()) {
            if (e.getValue() != null) continue;
            next = e;
            break;
        }
        if (AbstractMWEDesc.isFillerForSlot(t, (IMWEDesc.IPart)next.getKey())) {
            next.setValue(t);
            return true;
        }
        return false;
    }
}

