/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.FilterByScore;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.score.IScorer;
import edu.mit.jmwe.detect.score.LeskScore;
import edu.mit.jwi.IDictionary;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeskAtLeast
extends FilterByScore {
    protected final int minScore;
    protected final IDictionary dict;

    public LeskAtLeast(IMWEDetector detector, IDictionary dict, int minScore) {
        super(detector);
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
        this.minScore = Math.max(minScore, 0);
    }

    @Override
    protected boolean isGoodScore(double score) {
        return score >= (double)this.minScore;
    }

    @Override
    protected <T extends IToken> IScorer<IMWE<T>> getScorer(List<T> sentence) {
        return new LeskScore<T>(sentence, this.dict);
    }
}

