/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorResolver;
import edu.mit.jmwe.util.ListComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LMLR
extends HasMWEDetector
implements IMWEDetectorResolver {
    public LMLR(IMWEDetector detector) {
        super(detector);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> s) {
        Object first;
        List<IMWE<T>> results = super.detect(s);
        LinkedHashMap<IToken, IMWE<T>> map = new LinkedHashMap<IToken, IMWE<T>>(s.size());
        for (IToken token : s) {
            map.put(token, null);
        }
        ListComparator<T> c = new ListComparator<T>(s);
        HashMap<IMWE<T>, T> firstTokens = new HashMap<IMWE<T>, T>(results.size());
        for (IMWE<T> mwe : results) {
            first = LMLR.getFirstToken(mwe.getTokens(), c);
            firstTokens.put(mwe, first);
            IMWE<T> filler = (IMWE<T>)map.get(first);
            filler = LMLR.longest(filler, mwe, c);
            map.put((IToken)first, filler);
        }
        for (IToken token : s) {
            IMWE mwe = (IMWE)map.get(token);
            if (mwe == null) continue;
            first = (IToken)firstTokens.get(mwe);
            for (IToken mweToken : mwe.getTokens()) {
                if (mweToken == first) continue;
                map.put(mweToken, null);
            }
        }
        results.retainAll(map.values());
        return results;
    }

    public static <T extends IToken> T getFirstToken(Iterable<? extends T> tokens, Comparator<T> c) {
        Iterator<T> i = tokens.iterator();
        if (!i.hasNext()) {
            throw new IllegalArgumentException();
        }
        IToken first = (IToken)i.next();
        while (i.hasNext()) {
            IToken next = (IToken)i.next();
            first = c.compare(first, next) <= 0 ? first : next;
        }
        return (T)first;
    }

    public static <T extends IToken> IMWE<T> longest(IMWE<T> one, IMWE<T> two, Comparator<T> c) {
        if (one == null && two == null) {
            throw new NullPointerException();
        }
        if (one == two) {
            return one;
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        if (one.getTokens().size() > two.getTokens().size()) {
            return one;
        }
        if (one.getTokens().size() < two.getTokens().size()) {
            return two;
        }
        for (int i = 0; i < one.getTokens().size(); ++i) {
            int cmp = c.compare(one.getTokens().get(i), two.getTokens().get(i));
            if (cmp < 0) {
                return one;
            }
            if (cmp <= 0) continue;
            return two;
        }
        return one;
    }
}

