/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEPOS;
import edu.mit.jmwe.detect.IInflectionRule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InflectionRule implements IInflectionRule
{
    R1("(NNS?)_(NNS?_)?(NNS?_)?(NNS?)", MWEPOS.NOUN, 4),
    R2("(NNS?)_(IN)_(DT_)?(NNS?)", MWEPOS.NOUN, 1),
    R3("(NNS?)_(POS)_(NNS?)", MWEPOS.NOUN, 3),
    R4("(JJ[RS]?)_(NNS?)", MWEPOS.NOUN, 2),
    R5("(NNS?)_(IN)_(JJ[RS]?)_(NNS?)", MWEPOS.NOUN, 1, 4),
    R6("(IN)_(NNS?)", MWEPOS.NOUN, 2),
    R7("(NNS?)_(CC)_(NNS?)", MWEPOS.NOUN, 1, 3),
    R8("(VB[DGNPZ]?)_(IN)(_W?RB[RS]?)?(_W?RB[RS]?)?", MWEPOS.VERB, 1),
    R9("(VB[DGNPZ]?)_(IN)(_IN)?(_W?RB[RS]?)?", MWEPOS.VERB, 1),
    R10("(VB[DGNPZ]?)_(IN)(_W?RB[RS]?)?(_IN)?", MWEPOS.VERB, 1),
    R11("(VB[DGNPZ]?)_(IN)(_IN)?(_IN)?", MWEPOS.VERB, 1),
    R12("(VB[DGNPZ]?)_(W?RB[RS]?)(_W?RB[RS]?)?(_W?RB[RS]?)?", MWEPOS.VERB, 1),
    R13("(VB[DGNPZ]?)_(W?RB[RS]?)(_IN)?(_W?RB[RS]?)?", MWEPOS.VERB, 1),
    R14("(VB[DGNPZ]?)_(W?RB[RS]?)(_W?RB[RS]?)?(_IN)?", MWEPOS.VERB, 1),
    R15("(VB[DGNPZ]?)_(W?RB[RS]?)(_IN)?(_IN)?", MWEPOS.VERB, 1),
    R16("(VB[DGNPZ]?)_(TO)_(VB[DGNPZ]?)", MWEPOS.VERB, 1),
    R17("(VB[DGNPZ]?)_(JJ[RS]?)", MWEPOS.VERB, 1),
    R18("(VB[DGNPZ]?)_(IN_)?(DT_)?(NNS?)", MWEPOS.VERB, 1, 4),
    R19("(VB[DGNPZ]?)_(IN_)?(PRP\\$_)?(NNS?)", MWEPOS.VERB, 1, 4),
    R20("(VB[DGNPZ]?)_(TO)", MWEPOS.VERB, 1),
    R21("(VB[DGNPZ]?)_(RP)", MWEPOS.VERB, 1);

    private final Pattern pattern;
    private final List<Integer> infIdxs;
    private final MWEPOS pos;
    private transient String toString;

    private InflectionRule(String regex, MWEPOS pos, Integer ... indicies) {
        this.pattern = Pattern.compile(regex);
        this.infIdxs = Arrays.asList(indicies);
        Collections.sort(this.infIdxs);
        this.pos = pos;
    }

    @Override
    public <T extends IToken> boolean isValid(IMWE<T> mwe) {
        Matcher matcher = this.pattern.matcher(this.getTagPattern(mwe));
        if (!matcher.matches()) {
            System.err.println("MWE does not match this rule's syntax. Cannot apply rule");
            throw new IllegalArgumentException();
        }
        int j = 0;
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            if (matcher.group(i) == null) continue;
            if (InflectionRule.inflects((IToken)mwe.getTokens().get(j), mwe) && !this.infIdxs.contains(i)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    @Override
    public <T extends IToken> boolean matches(IMWE<T> mwe) {
        if (mwe.getEntry().getPOS() != this.pos) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(this.getTagPattern(mwe));
        return matcher.matches();
    }

    public <T extends IToken> String getTagPattern(IMWE<T> mwe) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> itr = mwe.getTokens().iterator();
        while (itr.hasNext()) {
            sb.append(((IToken)itr.next()).getTag());
            if (!itr.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name());
            sb.append('(');
            sb.append(this.pos.getIdentifier());
            sb.append(')');
            sb.append(':');
            sb.append(this.pattern.pattern());
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public static <T extends IToken> boolean inflects(T token, IMWE<T> mwe) {
        String partlemma = mwe.getPartMap().get(token).getForm();
        return !token.getForm().equalsIgnoreCase(partlemma);
    }

    public static boolean isInflectedByPattern(IMWE<?> mwe) {
        for (InflectionRule r : InflectionRule.values()) {
            if (!r.matches(mwe) || !r.isValid(mwe)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInflectedByPattern(IMWE<?> mwe, Collection<? extends IInflectionRule> rules) {
        for (IInflectionRule iInflectionRule : rules) {
            if (!iInflectionRule.matches(mwe) || !iInflectionRule.isValid(mwe)) continue;
            return true;
        }
        return false;
    }
}

