/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IInflectionRule;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorFilter;
import edu.mit.jmwe.detect.InflectionRule;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflectionPattern
extends HasMWEDetector
implements IMWEDetectorFilter {
    private static final Set<IInflectionRule> rules = Collections.unmodifiableSet(EnumSet.allOf(InflectionRule.class));

    public InflectionPattern(IMWEDetector d) {
        super(d);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> results = super.detect(sentence);
        Iterator<IMWE<T>> i = results.iterator();
        while (i.hasNext()) {
            IMWE<T> mwe = i.next();
            if (!mwe.isInflected() || InflectionRule.isInflectedByPattern(mwe, this.getRules())) continue;
            i.remove();
        }
        return results;
    }

    public Collection<IInflectionRule> getRules() {
        return rules;
    }
}

