/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IInfMWEDesc;
import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.InfMWEDesc;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorFilter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflectionLookup
extends HasMWEDetector
implements IMWEDetectorFilter {
    public InflectionLookup(IMWEDetector d) {
        super(d);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> found = super.detect(sentence);
        Iterator<IMWE<T>> i = found.iterator();
        block0: while (i.hasNext()) {
            IMWEDesc base;
            IMWE<T> mwe = i.next();
            if (!mwe.isInflected() || (base = mwe.getEntry()) instanceof IInfMWEDesc) continue;
            if (base instanceof IRootMWEDesc) {
                IRootMWEDesc root = (IRootMWEDesc)base;
                IInfMWEDesc inf = InflectionLookup.getSurfaceFormDescription(root, mwe);
                for (IInfMWEDesc iInfMWEDesc : root.getInflected().values()) {
                    if (!iInfMWEDesc.equals(inf)) continue;
                    continue block0;
                }
            }
            i.remove();
        }
        return found;
    }

    public static <T extends IToken> IInfMWEDesc getSurfaceFormDescription(IRootMWEDesc root, IMWE<T> mwe) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> i = mwe.getTokens().iterator();
        while (i.hasNext()) {
            IToken token = (IToken)i.next();
            sb.append(token.getForm().toLowerCase());
            if (!i.hasNext()) continue;
            sb.append('_');
        }
        return new InfMWEDesc(root, sb.toString());
    }
}

