/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorFilter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InOrder
extends HasMWEDetector
implements IMWEDetectorFilter {
    public InOrder(IMWEDetector d) {
        super(d);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> results = super.detect(sentence);
        Iterator<IMWE<T>> i = results.iterator();
        while (i.hasNext()) {
            if (!InOrder.isOutOfOrder(i.next())) continue;
            i.remove();
        }
        return results;
    }

    public static <T extends IToken> boolean isOutOfOrder(IMWE<T> mwe) {
        Iterator<T> tokens = mwe.getTokens().iterator();
        Iterator<T> parts = mwe.getPartMap().keySet().iterator();
        while (tokens.hasNext() && parts.hasNext()) {
            if (tokens.next() == parts.next()) continue;
            return true;
        }
        return false;
    }
}

