/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorFilter;
import edu.mit.jmwe.detect.score.IScorer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterByScore
extends HasMWEDetector
implements IMWEDetectorFilter {
    public FilterByScore(IMWEDetector detector) {
        super(detector);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> results = super.detect(sentence);
        IScorer<IMWE<IMWE<T>>> scorer = this.getScorer(sentence);
        Iterator<IMWE<T>> i = results.iterator();
        while (i.hasNext()) {
            if (this.isGoodScore(scorer.score(i.next()))) continue;
            i.remove();
        }
        return new ArrayList<IMWE<T>>(results);
    }

    protected abstract boolean isGoodScore(double var1);

    protected abstract <T extends IToken> IScorer<IMWE<T>> getScorer(List<T> var1);
}

