/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.data.StopWords;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.MWEBuilder;
import edu.mit.jmwe.index.HasMWEIndex;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.util.ListComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exhaustive
extends HasMWEIndex
implements IMWEDetector {
    public Exhaustive(IMWEIndex index) {
        super(index);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        IMWE mwe;
        IMWEIndex index = this.getMWEIndex();
        HashMap recordMap = new HashMap();
        ListComparator<T> comparator = new ListComparator<T>(sentence);
        HashSet<IRootMWEDesc> entries = new HashSet<IRootMWEDesc>();
        HashSet<String> foundStopWords = new HashSet<String>();
        ArrayList<IToken> stopTokens = new ArrayList<IToken>();
        for (IToken token : sentence) {
            entries.clear();
            if (this.getStopWords().contains(token.getForm().toLowerCase())) {
                stopTokens.add(token);
                foundStopWords.add(token.getForm().toLowerCase());
                continue;
            }
            entries.addAll(index.get(token.getForm().toLowerCase()));
            if (token.getStems() != null) {
                for (String stem : token.getStems()) {
                    if (stem.equals(token.getForm().toLowerCase())) continue;
                    entries.addAll(index.get(stem));
                }
            }
            for (IRootMWEDesc entry : entries) {
                HashSet records = (HashSet)recordMap.get(entry);
                if (records == null) {
                    records = new HashSet();
                    recordMap.put(entry, records);
                }
                records.add(new MWEBuilder<T>((IMWEDesc)entry, comparator));
                MWEBuilder.fillSlots(records, token);
            }
        }
        LinkedList<IMWE<T>> results = new LinkedList<IMWE<T>>();
        HashSet stopRecords = new HashSet();
        for (Set set : recordMap.values()) {
            block4: for (MWEBuilder rec : set) {
                if (rec.isFull() && !this.containsDuplicate(results, mwe = rec.toMWE())) {
                    results.add(mwe);
                    continue;
                }
                if (!rec.isContentFull()) continue;
                for (IMWEDesc.IPart part : rec.getSlots().keySet()) {
                    if (!foundStopWords.contains(part.getForm())) continue;
                    stopRecords.add(rec);
                    continue block4;
                }
            }
        }
        for (IToken iToken : stopTokens) {
            MWEBuilder.fillSlots(stopRecords, iToken);
        }
        for (MWEBuilder mWEBuilder : stopRecords) {
            if (!mWEBuilder.isFull() || this.containsDuplicate(results, mwe = mWEBuilder.toMWE())) continue;
            results.add(mwe);
        }
        Collections.sort(results, new MWEComparator<T>(sentence));
        return results;
    }

    protected Set<String> getStopWords() {
        return StopWords.get();
    }

    protected <T extends IToken> boolean containsDuplicate(Collection<? extends IMWE<T>> results, IMWE<T> mwe) {
        for (IMWE<T> result : results) {
            if (result.getEntry().getPOS() != mwe.getEntry().getPOS() || !new HashSet<T>(result.getTokens()).equals(new HashSet<T>(mwe.getTokens()))) continue;
            return true;
        }
        return false;
    }
}

