/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.HasMWEDetector;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.IMWEDetectorFilter;
import edu.mit.jmwe.util.AbstractIndexComparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Continuous
extends HasMWEDetector
implements IMWEDetectorFilter {
    public Continuous(IMWEDetector d) {
        super(d);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        List<IMWE<T>> results = super.detect(sentence);
        if (!results.isEmpty()) {
            Map<T, Integer> idxMap = MWEComparator.createIndexMap(sentence);
            Iterator<IMWE<T>> i = results.iterator();
            while (i.hasNext()) {
                if (!Continuous.isDiscontinuous(i.next(), idxMap)) continue;
                i.remove();
            }
        }
        return results;
    }

    public static <T extends IToken> boolean isDiscontinuous(IMWE<T> mwe, List<T> sentence) {
        return Continuous.isDiscontinuous(mwe, AbstractIndexComparator.createIndexMap(sentence));
    }

    public static <T extends IToken> boolean isDiscontinuous(IMWE<T> mwe, Map<T, Integer> indexMap) {
        IToken first = (IToken)mwe.getPartMap().keySet().iterator().next();
        int idx = indexMap.get(first);
        for (IToken token : mwe.getPartMap().keySet()) {
            if (indexMap.get(token) == idx++) continue;
            return true;
        }
        return false;
    }
}

