/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.FilterByScore;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.score.IScorer;
import edu.mit.jmwe.detect.score.LengthScore;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainLength
extends FilterByScore {
    protected final int length;
    protected final boolean isMaxLength;

    public ConstrainLength(IMWEDetector detector, int length, boolean isMaxLength) {
        super(detector);
        this.length = Math.max(0, length);
        this.isMaxLength = isMaxLength;
    }

    @Override
    protected boolean isGoodScore(double score) {
        return this.isMaxLength ? score <= (double)this.length : score > (double)this.length;
    }

    @Override
    protected <T extends IToken> IScorer<IMWE<T>> getScorer(List<T> sentence) {
        return LengthScore.getInstance();
    }
}

