/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.MWEBuilder;
import edu.mit.jmwe.index.HasMWEIndex;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.util.ListComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Consecutive
extends HasMWEIndex
implements IMWEDetector {
    public Consecutive(IMWEIndex index) {
        super(index);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sent) {
        ListComparator<T> c = new ListComparator<T>(sent);
        LinkedList<MWEBuilder<T>> inProgress = new LinkedList<MWEBuilder<T>>();
        LinkedList<MWEBuilder<T>> done = new LinkedList<MWEBuilder<T>>();
        for (Object t : sent) {
            MWEBuilder builder;
            Iterator iterator = inProgress.iterator();
            while (iterator.hasNext()) {
                builder = (MWEBuilder)iterator.next();
                if (this.fillNextSlot(builder, t)) continue;
                iterator.remove();
            }
            Set<? extends IMWEDesc> descs = this.getMWEDescs((IToken)t);
            if (descs != null) {
                for (IMWEDesc iMWEDesc : descs) {
                    builder = new MWEBuilder(iMWEDesc, c);
                    if (!this.fillNextSlot(builder, t)) continue;
                    inProgress.add(builder);
                }
            }
            Iterator iterator2 = inProgress.iterator();
            while (iterator2.hasNext()) {
                builder = (MWEBuilder)iterator2.next();
                if (!builder.isFull()) continue;
                iterator2.remove();
                done.add(builder);
            }
        }
        HashSet resultSet = new HashSet(done.size());
        for (MWEBuilder mWEBuilder : done) {
            resultSet.add(mWEBuilder.toMWE());
        }
        ArrayList<IMWE<T>> results = new ArrayList<IMWE<T>>(resultSet);
        Collections.sort(results, new MWEComparator<T>(sent));
        return results;
    }

    protected <T extends IToken> boolean fillNextSlot(MWEBuilder<T> builder, T t) {
        return MWEBuilder.fillNextSlot(builder, t);
    }

    protected Set<? extends IMWEDesc> getMWEDescs(IToken token) {
        HashSet<IRootMWEDesc> results = new HashSet<IRootMWEDesc>();
        IMWEIndex index = this.getMWEIndex();
        results.addAll(index.get(token.getForm().toLowerCase()));
        if (token.getStems() != null) {
            for (String stem : token.getStems()) {
                results.addAll(index.get(stem));
            }
        }
        return results;
    }
}

