/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.detect;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.data.MWEComparator;
import edu.mit.jmwe.detect.IMWEDetector;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDetector
extends AbstractList<IMWEDetector>
implements IMWEDetector {
    private final IMWEDetector[] backingArray;

    public CompositeDetector(IMWEDetector ... ds) {
        for (IMWEDetector d : ds) {
            if (d != null) continue;
            throw new NullPointerException();
        }
        this.backingArray = ds;
    }

    public CompositeDetector(List<? extends IMWEDetector> ds) {
        for (IMWEDetector iMWEDetector : ds) {
            if (iMWEDetector != null) continue;
            throw new NullPointerException();
        }
        this.backingArray = ds.toArray(new IMWEDetector[ds.size()]);
    }

    @Override
    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        LinkedHashSet<IMWE<T>> resultSet = new LinkedHashSet<IMWE<T>>();
        for (IMWEDetector d : this.backingArray) {
            resultSet.addAll(d.detect(sentence));
        }
        ArrayList<IMWE<T>> results = new ArrayList<IMWE<T>>(resultSet);
        Collections.sort(results, new MWEComparator<T>(sentence));
        return results;
    }

    @Override
    public IMWEDetector get(int index) {
        return this.backingArray[index];
    }

    @Override
    public int size() {
        return this.backingArray.length;
    }
}

