/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data.concordance;

import edu.mit.jmwe.data.concordance.ConcordanceSentence;
import edu.mit.jmwe.data.concordance.IConcordanceSentence;
import edu.mit.jmwe.util.StreamAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedConcordanceIterator
implements Iterator<IConcordanceSentence> {
    protected final BufferedReader source;
    protected IConcordanceSentence next;

    public TaggedConcordanceIterator(File file) throws IOException {
        this(new InputStreamReader(StreamAdapter.make(file)));
    }

    public TaggedConcordanceIterator(URL url) throws IOException {
        this(new InputStreamReader(StreamAdapter.make(url)));
    }

    public TaggedConcordanceIterator(Reader r) throws IOException {
        this.source = new BufferedReader(r);
        this.advance();
    }

    @Override
    public IConcordanceSentence next() {
        IConcordanceSentence result = this.next;
        try {
            this.advance();
        }
        catch (IOException e) {
            throw new NoSuchElementException(e.getLocalizedMessage());
        }
        return result;
    }

    protected void advance() throws IOException {
        String line;
        this.next = null;
        while ((line = this.source.readLine()) != null) {
            if (this.ignoreLine(line)) continue;
            this.next = ConcordanceSentence.parse(line);
            break;
        }
    }

    protected boolean ignoreLine(String line) {
        if ((line = line.trim()).length() == 0) {
            return true;
        }
        if (line.startsWith("//")) {
            return true;
        }
        return line.startsWith(";;");
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

