/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jmwe.data.concordance;

import edu.mit.jmwe.data.IMWEDesc;
import edu.mit.jmwe.data.IRootMWEDesc;
import edu.mit.jmwe.data.Token;
import edu.mit.jmwe.data.concordance.IConcordanceToken;
import edu.mit.jsemcor.element.ISentence;
import edu.mit.jsemcor.element.IToken;
import edu.mit.jsemcor.element.IWordform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcordanceToken
extends Token
implements IConcordanceToken {
    private final int partNum;
    private final int tokenNum;
    private transient String toString;
    public static final Pattern semcorTokenPattern = Pattern.compile("([\\S&&[^_]]+)_([\\S&&[^_]]+)_(\\S*?)_(\\d+)_(\\d+)");
    public static final Pattern whitespaceDelimited = Pattern.compile("\\s+");

    public ConcordanceToken(String text, String tag, int tokenNum, int partNum, String ... stems) {
        super(text, tag, stems);
        if (tokenNum < 0) {
            throw new IllegalArgumentException();
        }
        if (partNum < 0) {
            throw new IllegalArgumentException();
        }
        this.tokenNum = tokenNum;
        this.partNum = partNum;
    }

    @Override
    public int getTokenNumber() {
        return this.tokenNum;
    }

    @Override
    public int getPartNumber() {
        return this.partNum;
    }

    @Override
    public String toString() {
        if (this.toString == null) {
            this.toString = ConcordanceToken.toString(this);
        }
        return this.toString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.partNum;
        result = 31 * result + this.tokenNum;
        result = 31 * result + this.getForm().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ConcordanceToken other = (ConcordanceToken)obj;
        if (this.partNum != other.partNum) {
            return false;
        }
        if (this.tokenNum != other.tokenNum) {
            return false;
        }
        return this.getForm().equals(other.getForm());
    }

    public static String toString(IConcordanceToken token) {
        StringBuilder sb = new StringBuilder();
        sb.append(token.getForm());
        sb.append('_');
        if (token.getTag() != null) {
            sb.append(token.getTag());
        }
        sb.append('_');
        if (token.getStems() != null) {
            Iterator<String> i = token.getStems().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append('_');
            }
        }
        sb.append('_');
        sb.append(Integer.toString(token.getTokenNumber()));
        sb.append('_');
        sb.append(Integer.toString(token.getPartNumber()));
        return sb.toString();
    }

    public static ConcordanceToken parse(String str) {
        try {
            Matcher matcher = semcorTokenPattern.matcher(str.trim());
            if (!matcher.matches()) {
                throw new IllegalArgumentException();
            }
            String text = matcher.group(1);
            String tag = matcher.group(2);
            int tokenNum = Integer.parseInt(matcher.group(4));
            int partNum = Integer.parseInt(matcher.group(5));
            String stemList = matcher.group(3);
            String[] stems = stemList.trim().length() == 0 ? new String[]{} : IRootMWEDesc.underscore.split(stemList);
            return new ConcordanceToken(text, tag, tokenNum, partNum, stems);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Exception parsing token: " + str, t);
        }
    }

    public static List<ConcordanceToken> parseList(String str) {
        String[] fields = whitespaceDelimited.split(str = str.trim());
        if (fields.length == 0) {
            throw new IllegalArgumentException();
        }
        LinkedList<ConcordanceToken> results = new LinkedList<ConcordanceToken>();
        for (String field : fields) {
            results.add(ConcordanceToken.parse(field));
        }
        return results;
    }

    public static List<ConcordanceToken> toTokens(IToken t, int tokenNum, ISentence sent) {
        if (t instanceof IWordform) {
            IWordform wf = (IWordform)t;
            List ts = wf.getConstituentTokens();
            ArrayList<ConcordanceToken> result = new ArrayList<ConcordanceToken>(ts.size());
            for (int i = 0; i < ts.size(); ++i) {
                result.add(ConcordanceToken.toToken(tokenNum, i, wf, sent));
            }
            return result;
        }
        ConcordanceToken result = new ConcordanceToken(t.getText(), null, tokenNum, 0, (String[])null);
        return Collections.singletonList(result);
    }

    public static ConcordanceToken toToken(int tokenNum, int partNum, IWordform wf, ISentence sent) {
        String[] stringArray;
        String text = (String)wf.getConstituentTokens().get(partNum);
        String lemma = null;
        String tag = null;
        String markedLemma = null;
        String[] lemmaParts = null;
        if (wf.getSemanticTag() != null) {
            markedLemma = wf.getSemanticTag().getLemma();
        }
        int lemmaNum = partNum;
        if (markedLemma == null && wf.getDistance() != 0) {
            IWordform headWf;
            List split = null;
            int idx = -1;
            for (List wfs : sent.getCollocations()) {
                idx = wfs.indexOf(wf);
                if (idx <= -1) continue;
                split = wfs;
                break;
            }
            if ((headWf = (IWordform)split.get(0)).getSemanticTag() != null) {
                markedLemma = headWf.getSemanticTag().getLemma();
                lemmaNum = idx;
            }
        }
        if (markedLemma != null) {
            lemmaParts = IMWEDesc.underscore.split(markedLemma);
        }
        if (wf.getConstituentTokens().size() == 1) {
            if (wf.getPOSTag() != null) {
                tag = wf.getPOSTag().getValue();
            }
            if (lemmaParts != null) {
                lemma = lemmaParts[lemmaNum];
            }
        } else if (lemmaParts != null) {
            lemma = lemmaParts.length == wf.getConstituentTokens().size() ? lemmaParts[lemmaNum] : null;
        }
        if (lemma == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lemma;
        }
        String[] stems = stringArray;
        return new ConcordanceToken(text, tag, tokenNum, partNum, stems);
    }
}

